/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.contract;

import com.bxm.fossicker.thirdparty.service.impl.contract.WxContractPayService;
import com.bxm.fossicker.thirdparty.service.impl.contract.WxPayContractOrderNotifyResult;
import com.bxm.fossicker.thirdparty.service.impl.contract.WxPayContractOrderRequest;
import com.bxm.fossicker.thirdparty.service.impl.contract.WxPayContractOrderResult;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxContractPayServiceImpl
extends WxPayServiceImpl
implements WxContractPayService {
    private static final Logger log = LoggerFactory.getLogger(WxContractPayServiceImpl.class);

    @Override
    public WxPayContractOrderResult contractorder(WxPayContractOrderRequest request) throws WxPayException {
        request.checkAndSign(this.getConfig());
        String url = this.getPayBaseUrl() + "/pay/contractorder";
        String responseContent = this.post(url, request.toXML(), false);
        WxPayContractOrderResult result = (WxPayContractOrderResult)BaseWxPayResult.fromXML((String)responseContent, WxPayContractOrderResult.class);
        result.checkResult(this, request.getSignType(), true);
        return result;
    }

    @Override
    public WxPayContractOrderNotifyResult parseContractNotify(String resultStr) throws WxPayException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u5fae\u4fe1\u7b7e\u7ea6\u5f02\u6b65\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)resultStr);
            }
            WxPayContractOrderNotifyResult result = (WxPayContractOrderNotifyResult)WxPayContractOrderNotifyResult.fromXML((String)resultStr, WxPayContractOrderNotifyResult.class);
            result.checkResult(this, this.getConfig().getSignType(), true);
            return result;
        }
        catch (WxPayException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new WxPayException("\u53d1\u751f\u5f02\u5e38\uff0c" + e.getMessage(), (Throwable)e);
        }
    }
}

