/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.pay;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.TelephoneChargeFacadeService;
import com.bxm.fossicker.base.facade.PointReportFacadeService;
import com.bxm.fossicker.base.facade.param.PointParam;
import com.bxm.fossicker.thirdpart.facade.config.PaymentProperties;
import com.bxm.fossicker.thirdpart.facade.dto.PaymentOrderDTO;
import com.bxm.fossicker.thirdpart.facade.param.PaymentRefundParam;
import com.bxm.fossicker.thirdparty.domain.UserPayorderRefundMapper;
import com.bxm.fossicker.thirdparty.model.vo.UserPayorderRefundBean;
import com.bxm.fossicker.thirdparty.service.PaymentService;
import com.bxm.fossicker.user.facade.RealityCardFacadeService;
import com.bxm.fossicker.user.facade.UserPayorderInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.PayorderInfoDTO;
import com.bxm.fossicker.user.facade.enums.UserPayorderInfoStatusEnum;
import com.bxm.fossicker.user.facade.param.TobeVipParam;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.fossicker.vo.BasicParam;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPaymentService<T extends PaymentOrderDTO>
extends BaseService
implements PaymentService<T> {
    @Autowired
    private VipFacadeService vipFacadeService;
    @Autowired
    private RealityCardFacadeService realityCardFacadeService;
    @Autowired
    private UserPayorderRefundMapper userPayorderRefundMapper;
    @Autowired
    protected UserPayorderInfoFacadeService userPayorderInfoFacadeService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    protected PaymentProperties paymentProperties;
    @Autowired
    private TelephoneChargeFacadeService telephoneChargeFacadeService;
    @Autowired
    private PointReportFacadeService pointReportFacadeService;

    protected void afterPayment(PayorderInfoDTO payorderInfoDTO) {
        this.logger.info("\u652f\u4ed8\u5b8c\u6210\uff0c\u8fdb\u884c\u540e\u7eed\u5904\u7406\uff0c\u652f\u4ed8\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)payorderInfoDTO));
        try {
            int vipType = this.getVipType(payorderInfoDTO.getGoodsType());
            this.activeUserVip(payorderInfoDTO, vipType);
            if (Objects.equals(payorderInfoDTO.getGoodsType(), 5) || Objects.equals(payorderInfoDTO.getGoodsType(), 6)) {
                this.realityCardFacadeService.modifyPayStatus(payorderInfoDTO.getUserId());
            }
            if (Objects.equals(payorderInfoDTO.getGoodsType(), 7)) {
                this.telephoneChargeFacadeService.addTelephoneChargeList(payorderInfoDTO.getUserId(), Byte.valueOf((byte)1));
            }
            this.report(payorderInfoDTO);
        }
        catch (Exception e) {
            this.logger.error("\u652f\u4ed8\u540e\u7eed\u4e1a\u52a1\u53d1\u751f\u9519\u8bef\uff0c\u76f8\u5173\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)payorderInfoDTO));
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void report(PayorderInfoDTO payorderInfoDTO) {
        BasicParam basicParam = new BasicParam();
        this.pointReportFacadeService.add(PointParam.build((BasicParam)basicParam).put("uid", String.valueOf(payorderInfoDTO.getUserId())).e("3034").ev("110." + payorderInfoDTO.getGoodsType()));
    }

    private void activeUserVip(PayorderInfoDTO payorderInfoDTO, int vipType) {
        TobeVipParam tobeVipParam = new TobeVipParam();
        tobeVipParam.setType(vipType);
        tobeVipParam.setUserId(payorderInfoDTO.getUserId());
        tobeVipParam.setBasicInfo(payorderInfoDTO.getBasicInfo());
        tobeVipParam.setRelationId(Objects.toString(payorderInfoDTO.getId(), ""));
        tobeVipParam.setPayAmt(payorderInfoDTO.getMoney());
        if (vipType == 4 || vipType == 3) {
            this.vipFacadeService.tobeVipForV2(tobeVipParam);
        } else {
            this.vipFacadeService.tobeVip(tobeVipParam);
        }
    }

    private int getVipType(Integer goodsType) {
        if (Objects.nonNull(goodsType)) {
            if (Objects.equals(goodsType, 2)) {
                return 2;
            }
            if (Objects.equals(goodsType, 3) || Objects.equals(goodsType, 5) || Objects.equals(goodsType, 6)) {
                return 3;
            }
            if (Objects.equals(goodsType, 4)) {
                return 4;
            }
            if (Objects.equals(goodsType, 7)) {
                return 4;
            }
        }
        return 0;
    }

    protected void createRefundOrder(PaymentRefundParam param, String refundOrderNo, BigDecimal refundFee) {
        UserPayorderRefundBean history = this.userPayorderRefundMapper.selectByOrderNo(refundOrderNo);
        UserPayorderRefundBean refundBean = UserPayorderRefundBean.builder().id(this.sequenceCreater.nextLongId()).createTime(new Date()).operatorId(param.getOperatorId()).orderId(param.getPayOrder().getId()).refundOrderNo(refundOrderNo).refundFee(refundFee).remark(param.getRemark()).status(UserPayorderInfoStatusEnum.REFUNDING.getStatus()).build();
        if (null != history) {
            refundBean.setId(history.getId());
            refundBean.setResult("");
            refundBean.setCreateTime(null);
            this.userPayorderRefundMapper.updateByPrimaryKeySelective(refundBean);
        } else {
            this.userPayorderRefundMapper.insert(refundBean);
        }
        this.userPayorderInfoFacadeService.updateOrderInfo(param.getOrderNo(), UserPayorderInfoStatusEnum.REFUNDING.getStatus(), null);
    }

    protected void changeRefundOrderStatus(String refundOrderNo, String refundTradeNo, String result, UserPayorderInfoStatusEnum status) {
        this.userPayorderRefundMapper.updateByOrderNo(UserPayorderRefundBean.builder().refundOrderNo(refundOrderNo).refundTradeNo(refundTradeNo).result(result).status(status.getStatus()).build());
        this.userPayorderInfoFacadeService.updateOrderInfo(this.restoreRefundOrderNo(refundOrderNo), status.getStatus(), null);
    }

    protected String buildRefundOrderNo(PaymentRefundParam param) {
        return "R" + param.getPayOrder().getOrderNo();
    }

    private String restoreRefundOrderNo(String refundOrderNo) {
        return StringUtils.replaceFirst((String)refundOrderNo, (String)"R", (String)"");
    }
}

