/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.pay;

import com.bxm.fossicker.thirdpart.facade.dto.PaymentOrderDTO;
import com.bxm.fossicker.thirdpart.facade.enums.PayTypeEnum;
import com.bxm.fossicker.thirdpart.facade.param.PaymentRefundParam;
import com.bxm.fossicker.thirdpart.facade.param.UserPayOrderInfoContext;
import com.bxm.fossicker.thirdpart.facade.service.PayMethodAdapter;
import com.bxm.fossicker.thirdparty.service.PaymentService;
import com.bxm.fossicker.thirdparty.service.impl.pay.DefaultPaymentService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PayMethodAdapterImpl
implements PayMethodAdapter {
    private static final Logger log = LoggerFactory.getLogger(PayMethodAdapterImpl.class);
    private Map<PayTypeEnum, PaymentService> payModeMap;
    private PaymentService defaultPayment = new DefaultPaymentService();

    public PaymentOrderDTO create(UserPayOrderInfoContext context) {
        return this.obtainPayment(context.getPayType()).create(context);
    }

    public String notifyPay(String data, PayTypeEnum payType) {
        return this.obtainPayment(payType).callBack(data);
    }

    public Message submitRefund(PaymentRefundParam param) {
        Preconditions.checkArgument((null != param ? 1 : 0) != 0);
        Preconditions.checkArgument((null != param.getPayOrder() ? 1 : 0) != 0);
        return this.obtainPayment(param.getPayOrder().getPayType()).submitRefund(param);
    }

    public String execRefundCallback(String request, PayTypeEnum payType) {
        return this.obtainPayment(payType).execRefundCallback(request);
    }

    private PaymentService obtainPayment(PayTypeEnum payType) {
        PaymentService service = this.getPayModeMap().get(payType);
        if (service == null) {
            log.error("\u8bf7\u6c42\u7684\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e3a\uff1a{}", (Object)payType);
            return this.defaultPayment;
        }
        return service;
    }

    private PaymentService obtainPayment(String payType) {
        try {
            PayTypeEnum type = PayTypeEnum.getPayTypeEnum((String)payType);
            return this.obtainPayment(type);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u7684\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e3a\uff1a{}", (Object)payType);
            return this.defaultPayment;
        }
    }

    private Map<PayTypeEnum, PaymentService> getPayModeMap() {
        if (null == this.payModeMap) {
            this.payModeMap = Maps.newHashMap();
            Collection paymentServices = SpringContextHolder.getBeans(PaymentService.class);
            for (PaymentService paymentService : paymentServices) {
                if (paymentService.support() == null) continue;
                this.payModeMap.put(paymentService.support(), paymentService);
            }
        }
        return this.payModeMap;
    }
}

