/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.pay;

import com.bxm.fossicker.thirdpart.facade.dto.BaseWithdrawDTO;
import com.bxm.fossicker.thirdpart.facade.param.PaymentRefundParam;
import com.bxm.fossicker.thirdpart.facade.param.WithdrawParam;
import com.bxm.fossicker.thirdpart.facade.service.PayMethodAdapter;
import com.bxm.fossicker.thirdpart.facade.service.WithdrawFacadeService;
import com.bxm.fossicker.thirdparty.service.WithdrawService;
import com.bxm.fossicker.user.facade.UserPayorderInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.PayorderInfoDTO;
import com.bxm.fossicker.user.facade.enums.UserPayorderInfoStatusEnum;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WithdrawFacadeServiceImpl
implements WithdrawFacadeService {
    private static final Logger log = LoggerFactory.getLogger(WithdrawFacadeServiceImpl.class);
    private final WithdrawService withdrawService;
    private final PayMethodAdapter payMethodAdapter;
    private final UserPayorderInfoFacadeService userPayorderInfoFacadeService;

    @Autowired
    public WithdrawFacadeServiceImpl(WithdrawService withdrawService, PayMethodAdapter payMethodAdapter, UserPayorderInfoFacadeService userPayorderInfoFacadeService) {
        this.withdrawService = withdrawService;
        this.payMethodAdapter = payMethodAdapter;
        this.userPayorderInfoFacadeService = userPayorderInfoFacadeService;
    }

    public BaseWithdrawDTO withdraw(WithdrawParam withdrawParam) {
        return this.withdrawService.withdraw(withdrawParam);
    }

    public Message submitRefund(PaymentRefundParam param) {
        PayorderInfoDTO payorderInfo = this.userPayorderInfoFacadeService.getByOrderNo(param.getOrderNo());
        if (payorderInfo == null) {
            log.info("\u63d0\u4ea4\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object)param);
            return Message.build((boolean)false, (String)("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355\u7f16\u53f7\u4e3a\uff1a" + param.getOrderNo()));
        }
        if (!Objects.equals(UserPayorderInfoStatusEnum.PAY_SUCCESS.getStatus(), payorderInfo.getStatus()) && !Objects.equals(UserPayorderInfoStatusEnum.REFUND_FAIL.getStatus(), payorderInfo.getStatus())) {
            log.info("\u63d0\u4ea4\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object)param);
            return Message.build((boolean)false, (String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u6b3e");
        }
        if (param.getFullAmount() != null && !param.getFullAmount().booleanValue()) {
            if (param.getRefundFee() == null) {
                return Message.build((boolean)false, (String)"\u975e\u5168\u6b3e\u9000\u6b3e\u5fc5\u987b\u6307\u5b9a\u5177\u4f53\u7684\u9000\u6b3e\u91d1\u989d");
            }
            if (param.getRefundFee().compareTo(payorderInfo.getMoney()) > 0) {
                return Message.build((boolean)false, (String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u53ef\u5927\u4e8e\u652f\u4ed8\u8ba2\u5355\u91d1\u989d");
            }
        }
        param.setPayOrder(payorderInfo);
        return this.payMethodAdapter.submitRefund(param);
    }
}

