/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.pay;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.thirdpart.facade.dto.WxH5ContractDTO;
import com.bxm.fossicker.thirdpart.facade.dto.WxPayDTO;
import com.bxm.fossicker.thirdpart.facade.param.WxH5ContractParam;
import com.bxm.fossicker.thirdpart.facade.param.WxPayParam;
import com.bxm.fossicker.thirdpart.facade.service.WxPayFacadeService;
import com.bxm.fossicker.thirdparty.service.impl.contract.WxContractPayServiceImpl;
import com.bxm.fossicker.thirdparty.service.impl.contract.WxPayContractOrderRequest;
import com.bxm.fossicker.thirdparty.service.impl.contract.WxPayContractOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxPayUnifiedOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxPayFacadeServiceImpl
implements WxPayFacadeService {
    private static final Logger log = LoggerFactory.getLogger(WxPayFacadeServiceImpl.class);
    @Autowired
    private WxPayService wxH5PayService;

    public WxPayDTO h5Pay(WxPayParam wxPayParam) {
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = WxPayUnifiedOrderRequest.newBuilder().body(wxPayParam.getBody()).notifyUrl(wxPayParam.getNotify_url()).spbillCreateIp(wxPayParam.getSpbill_create_ip()).totalFee(Integer.valueOf(wxPayParam.getTotal_fee())).sceneInfo(wxPayParam.getScene_info()).outTradeNo(wxPayParam.getOut_trade_no()).build();
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u8d77\u5fae\u4fe1\u3010\u652f\u4ed8\u3011\u8bf7\u6c42\u6570\u636e: {}", (Object)JSON.toJSONString((Object)wxPayUnifiedOrderRequest));
            }
            WxPayUnifiedOrderResult wpuor = this.wxH5PayService.unifiedOrder(wxPayUnifiedOrderRequest);
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u8d77\u5fae\u4fe1\u3010\u652f\u4ed8\u3011\u8fd4\u56de\u6570\u636e: {}", (Object)JSON.toJSONString((Object)wpuor));
            }
            if (Objects.nonNull(wpuor) && Objects.equals("SUCCESS", wpuor.getReturnCode()) && Objects.equals("SUCCESS", wpuor.getResultCode())) {
                return WxPayDTO.newBuilder().mweb_url(wpuor.getMwebUrl()).prepay_id(wpuor.getPrepayId()).trade_type(wpuor.getTradeType()).build();
            }
            log.warn("\u53d1\u8d77\u5fae\u4fe1\u3010\u652f\u4ed8\u3011\u5931\u8d25\uff0c\u8fd4\u56de\u6570\u636e: {}", (Object)JSON.toJSONString((Object)wpuor));
        }
        catch (WxPayException e) {
            log.error("\u5411\u5fae\u4fe1\u53d1\u8d77H5\u652f\u4ed8\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\n{}", (Object)e.getXmlString());
        }
        return WxPayDTO.newBuilder().build();
    }

    public WxH5ContractDTO h5Contract(WxH5ContractParam param) {
        WxPayContractOrderRequest request = WxPayContractOrderRequest.newBuilder().outTradeNo(param.getOutTradeNo()).body(param.getTradeOrderDesc()).notifyUrl(param.getNotifyUrl()).totalFee(param.getTotalFee()).spbillCreateIp(param.getSpbillCreateIp()).tradeType("MWEB").planId(param.getPlanId()).contractCode(param.getContractCode()).requestSerial(param.getRequestSerial()).contractDisplayAccount(param.getContractDisplayAccount()).contractNotifyUrl(param.getContractNotifyUrl()).build();
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u8d77\u5fae\u4fe1\u3010\u7b7e\u7ea6\u652f\u4ed8\u3011\u8bf7\u6c42\u6570\u636e: {}", (Object)JSON.toJSONString((Object)((Object)request)));
            }
            WxContractPayServiceImpl wxContractPayService = new WxContractPayServiceImpl();
            WxPayContractOrderResult orderResult = wxContractPayService.contractorder(request);
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u8d77\u5fae\u4fe1\u3010\u7b7e\u7ea6\u652f\u4ed8\u3011\u8fd4\u56de\u6570\u636e: {}", (Object)JSON.toJSONString((Object)((Object)orderResult)));
            }
            if (Objects.nonNull((Object)orderResult) && Objects.equals("SUCCESS", orderResult.getReturnCode()) && Objects.equals("SUCCESS", orderResult.getResultCode())) {
                return WxH5ContractDTO.builder().mwebUrl(orderResult.getMwebUrl()).outTradeNo(orderResult.getOutTradeNo()).build();
            }
            log.warn("\u53d1\u8d77\u5fae\u4fe1\u3010\u7b7e\u7ea6\u652f\u4ed8\u3011\u5931\u8d25\uff0c\u8fd4\u56de\u6570\u636e: {}", (Object)JSON.toJSONString((Object)((Object)orderResult)));
        }
        catch (WxPayException e) {
            log.error("\u5411\u5fae\u4fe1\u53d1\u8d77H5\u7b7e\u7ea6\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\n{}", (Object)e.getXmlString());
        }
        return WxH5ContractDTO.builder().build();
    }
}

