/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.pay.alipay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradePayModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeCreateRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeCreateResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.bxm.fossicker.common.config.BizConfigProperties;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.fossicker.thirdpart.facade.config.AlipayProperties;
import com.bxm.fossicker.thirdpart.facade.dto.PaymentOrderDTO;
import com.bxm.fossicker.thirdpart.facade.enums.PayTypeEnum;
import com.bxm.fossicker.thirdpart.facade.param.PaymentRefundParam;
import com.bxm.fossicker.thirdpart.facade.param.UserPayOrderInfoContext;
import com.bxm.fossicker.thirdparty.model.param.AlipayNotifyResult;
import com.bxm.fossicker.thirdparty.service.impl.pay.AbstractPaymentService;
import com.bxm.fossicker.user.facade.dto.PayorderInfoDTO;
import com.bxm.fossicker.user.facade.enums.UserPayorderInfoStatusEnum;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliPaymentServiceImpl
extends AbstractPaymentService<PaymentOrderDTO> {
    private static final Logger log = LoggerFactory.getLogger(AliPaymentServiceImpl.class);
    private final AlipayClient alipayClient;
    private final AlipayProperties alipayProperties;
    private final BizConfigProperties bizConfigProperties;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private static final String[] SUCCESS_STATUS = new String[]{"TRADE_FINISHED", "TRADE_SUCCESS"};
    private static final String SUCCESS_CODE = "10000";

    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.ALI_PAY;
    }

    @Override
    public PaymentOrderDTO create(UserPayOrderInfoContext context) {
        try {
            AlipayTradeCreateResponse response;
            if (StringUtils.isNotBlank((CharSequence)context.getBuyerId())) {
                response = (AlipayTradeCreateResponse)this.alipayClient.execute((AlipayRequest)this.createTradePayRequest(context));
                context.setLink(response.getBody());
                context.setOrderNo(context.getOrderNo());
                this.logger.info("\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1a[{}]", (Object)JSON.toJSONString((Object)response));
            } else {
                response = (AlipayTradeWapPayResponse)this.alipayClient.pageExecute((AlipayRequest)this.createWapPayRequest(context));
                context.setLink(response.getBody());
                context.setOrderNo(context.getOrderNo());
                this.logger.info("\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1a[{}]", (Object)JSON.toJSONString((Object)response));
            }
        }
        catch (AlipayApiException e) {
            this.logger.error("\u521b\u5efa\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)context), (Object)e);
            return null;
        }
        PaymentOrderDTO order = new PaymentOrderDTO(context.getLink(), context.getOrderNo());
        order.setMchId(this.alipayProperties.getAppId());
        return order;
    }

    private AlipayTradeCreateRequest createTradePayRequest(UserPayOrderInfoContext context) {
        AlipayTradeCreateRequest request = new AlipayTradeCreateRequest();
        request.setBizModel((AlipayObject)this.createTradePayModel(context));
        request.setNotifyUrl(this.alipayProperties.getNotifyUrl());
        request.setReturnUrl(this.bizConfigProperties.getH5ServerHost() + context.getReturnUrl() + "?orderNo=" + context.getOrderNo());
        return request;
    }

    private AlipayTradePayModel createTradePayModel(UserPayOrderInfoContext context) {
        AlipayTradePayModel model = new AlipayTradePayModel();
        model.setOutTradeNo(context.getOrderNo());
        model.setSubject("\u60e0\u597d\u7701\u7ec8\u8eab\u4f1a\u5458");
        model.setTotalAmount(String.valueOf(context.getMoney()));
        model.setBody("\u60e0\u597d\u7701\u7ec8\u8eab\u4f1a\u5458");
        model.setTimeoutExpress(this.alipayProperties.getTimeoutExpress());
        model.setBuyerId(context.getBuyerId());
        return model;
    }

    private AlipayTradeWapPayRequest createWapPayRequest(UserPayOrderInfoContext paymentOrderDetail) {
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setBizModel((AlipayObject)this.createWapPayModel(paymentOrderDetail));
        alipayRequest.setNotifyUrl(this.alipayProperties.getNotifyUrl());
        alipayRequest.setReturnUrl(this.bizConfigProperties.getH5ServerHost() + paymentOrderDetail.getReturnUrl() + "?orderNo=" + paymentOrderDetail.getOrderNo());
        return alipayRequest;
    }

    private AlipayTradeWapPayModel createWapPayModel(UserPayOrderInfoContext paymentOrderDetail) {
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(paymentOrderDetail.getOrderNo());
        model.setSubject("\u60e0\u597d\u7701\u7ec8\u8eab\u4f1a\u5458");
        model.setTotalAmount(String.valueOf(paymentOrderDetail.getMoney()));
        model.setBody("\u60e0\u597d\u7701\u7ec8\u8eab\u4f1a\u5458");
        model.setProductCode(this.alipayProperties.getProductCode());
        model.setTimeoutExpress(this.alipayProperties.getTimeoutExpress());
        return model;
    }

    @Override
    public String callBack(String data) {
        log.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)data);
        AlipayNotifyResult result = (AlipayNotifyResult)JSONObject.parseObject((String)data, AlipayNotifyResult.class);
        PayorderInfoDTO payorderInfoDTO = this.userPayorderInfoFacadeService.getByOrderNo(result.getOutTradeNo());
        if (payorderInfoDTO == null) {
            this.logger.error("\u63a5\u6536\u5230\u7684\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u9519\u8bef,\u652f\u4ed8\u8ba2\u5355[{}]\u4e0d\u5b58\u5728", (Object)result.getOutTradeNo());
            return null;
        }
        if (!UserPayorderInfoStatusEnum.WAIT_PAY.getStatus().equals(payorderInfoDTO.getStatus())) {
            this.logger.error("\u652f\u4ed8\u8ba2\u5355[{}]\u5df2\u5904\u7406\uff0c\u72b6\u6001\u4e3a\uff1a[{}]", (Object)result.getOutTradeNo(), (Object)payorderInfoDTO.getStatus());
            return null;
        }
        if (StringUtils.equalsAny((CharSequence)result.getTradeStatus(), (CharSequence[])SUCCESS_STATUS)) {
            this.userPayorderInfoFacadeService.updateOrderInfo(result.getOutTradeNo(), UserPayorderInfoStatusEnum.PAY_SUCCESS.getStatus(), result.getTradeNo());
            this.afterPayment(payorderInfoDTO);
            this.redisHashMapAdapter.remove(UserRedisKeyConstant.WX_PAY_ORDER_INFO, new String[]{result.getOutTradeNo()});
        }
        return null;
    }

    @Override
    public Message submitRefund(PaymentRefundParam param) {
        this.logger.debug("\u53d1\u8d77\u652f\u4ed8\u5b9d\u9000\u6b3e\u7533\u8bf7,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        BigDecimal totalFee = param.getPayOrder().getMoney();
        String outRefundNo = this.buildRefundOrderNo(param);
        BigDecimal refundFee = param.getFullAmount() != false ? totalFee : param.getRefundFee();
        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setOutTradeNo(param.getOrderNo());
        model.setOutRequestNo(outRefundNo);
        model.setRefundAmount(NumberUtils.format((double)refundFee.setScale(2, RoundingMode.HALF_DOWN).floatValue()));
        model.setRefundReason("\u8ba2\u5355\u9000\u6b3e");
        AlipayTradeRefundRequest tradeRefundRequest = new AlipayTradeRefundRequest();
        tradeRefundRequest.setBizModel((AlipayObject)model);
        try {
            this.createRefundOrder(param, outRefundNo, refundFee);
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)this.alipayClient.execute((AlipayRequest)tradeRefundRequest);
            if (!StringUtils.equalsAny((CharSequence)response.getCode(), (CharSequence[])new CharSequence[]{SUCCESS_CODE})) {
                log.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)response));
                this.changeRefundOrderStatus(outRefundNo, response.getTradeNo(), JSON.toJSONString((Object)response), UserPayorderInfoStatusEnum.REFUND_FAIL);
                return Message.build((boolean)false, (String)"\u9000\u6b3e\u7533\u8bf7\u5931\u8d25");
            }
            log.info("\u652f\u4ed8\u7533\u8bf7\u9000\u6b3e\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)response));
            this.changeRefundOrderStatus(outRefundNo, response.getTradeNo(), JSON.toJSONString((Object)response), UserPayorderInfoStatusEnum.REFUNDED);
        }
        catch (AlipayApiException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false, (String)"\u9000\u6b3e\u7533\u8bf7\u5f02\u5e38");
        }
        this.logger.debug("\u652f\u4ed8\u9000\u6b3e\u7533\u8bf7\u5904\u7406\u5b8c\u6210,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        return Message.build((boolean)true);
    }

    @Override
    public String execRefundCallback(String callbackRequest) {
        throw new UnsupportedOperationException("\u652f\u4ed8\u5b9d\u65e0\u9000\u6b3e\u56de\u8c03\u5904\u7406");
    }

    @Autowired
    public AliPaymentServiceImpl(AlipayClient alipayClient, AlipayProperties alipayProperties, BizConfigProperties bizConfigProperties, RedisHashMapAdapter redisHashMapAdapter) {
        this.alipayClient = alipayClient;
        this.alipayProperties = alipayProperties;
        this.bizConfigProperties = bizConfigProperties;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }
}

