/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.pay.wechat;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.fossicker.thirdpart.facade.dto.PaymentOrderDTO;
import com.bxm.fossicker.thirdpart.facade.param.PaymentRefundParam;
import com.bxm.fossicker.thirdparty.service.impl.pay.AbstractPaymentService;
import com.bxm.fossicker.user.facade.dto.PayorderInfoDTO;
import com.bxm.fossicker.user.facade.enums.UserPayorderInfoStatusEnum;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWechatPaymentService<T extends PaymentOrderDTO>
extends AbstractPaymentService<PaymentOrderDTO> {
    private static final Logger log = LoggerFactory.getLogger(AbstractWechatPaymentService.class);
    @Autowired
    protected WxPayService wxH5PayService;
    @Autowired
    protected DistributedLock distributedLock;
    @Autowired
    protected SequenceCreater sequenceCreater;
    @Autowired
    protected RedisHashMapAdapter redisHashMapAdapter;
    private static final String SUCCESS = "SUCCESS";

    @Override
    public String callBack(String data) {
        this.logger.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)data);
        try {
            WxPayOrderNotifyResult result = this.wxH5PayService.parseOrderNotifyResult(data);
            String requestId = this.sequenceCreater.nextStringId();
            if (this.distributedLock.lock(result.getOpenid(), requestId)) {
                String orderNo = result.getOutTradeNo();
                PayorderInfoDTO payorderInfoDTO = this.userPayorderInfoFacadeService.getByOrderNo(orderNo);
                if (Objects.nonNull(payorderInfoDTO) && Objects.equals(result.getResultCode(), SUCCESS) && Objects.equals(payorderInfoDTO.getStatus(), UserPayorderInfoStatusEnum.WAIT_PAY.getStatus())) {
                    int money = payorderInfoDTO.getMoney().multiply(new BigDecimal("100")).intValue();
                    if (Objects.equals(result.getTotalFee(), money)) {
                        this.userPayorderInfoFacadeService.updateOrderInfo(result.getOutTradeNo(), UserPayorderInfoStatusEnum.PAY_SUCCESS.getStatus(), result.getTransactionId());
                        this.afterPayment(payorderInfoDTO);
                        this.distributedLock.unlock(result.getOpenid(), requestId);
                        this.redisHashMapAdapter.remove(UserRedisKeyConstant.WX_PAY_ORDER_INFO, new String[]{result.getOutTradeNo()});
                        return this.buildSuccessResponse();
                    }
                }
            } else {
                log.warn("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u51fa\u73b0\u5e76\u53d1\uff0c\u83b7\u53d6\u6267\u884c\u6743\u9650\u5931\u8d25, openId: {}", (Object)result.getOpenid());
            }
        }
        catch (WxPayException e) {
            log.error("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u5f02\u5e38:", (Throwable)e);
        }
        return null;
    }

    private String buildSuccessResponse() {
        return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
    }

    @Override
    public String execRefundCallback(String callbackRequest) {
        log.info("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)callbackRequest);
        try {
            WxPayRefundNotifyResult notifyResult = this.wxH5PayService.parseRefundNotifyResult(callbackRequest);
            if (StringUtils.equals((CharSequence)notifyResult.getReturnCode(), (CharSequence)SUCCESS)) {
                if (StringUtils.equals((CharSequence)notifyResult.getReqInfo().getRefundStatus(), (CharSequence)SUCCESS)) {
                    this.changeRefundOrderStatus(notifyResult.getReqInfo().getOutRefundNo(), notifyResult.getReqInfo().getOutTradeNo(), JSON.toJSONString((Object)notifyResult.getReqInfo()), UserPayorderInfoStatusEnum.REFUNDED);
                } else {
                    log.error("\u9000\u6b3e\u4e1a\u52a1\u72b6\u6001\u5f02\u5e38\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}\uff0c\u56de\u8c03\u7ed3\u679c\uff1a{}", (Object)callbackRequest, (Object)JSON.toJSONString((Object)notifyResult));
                    this.changeRefundOrderStatus(notifyResult.getReqInfo().getOutRefundNo(), notifyResult.getReqInfo().getOutTradeNo(), JSON.toJSONString((Object)notifyResult.getReqInfo()), UserPayorderInfoStatusEnum.REFUND_FAIL);
                }
            } else {
                log.error("\u5fae\u4fe1\u9000\u6b3e\u5931\u8d25\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}\uff0c\u56de\u8c03\u7ed3\u679c\uff1a{}", (Object)callbackRequest, (Object)JSON.toJSONString((Object)notifyResult));
            }
            return this.buildSuccessResponse();
        }
        catch (WxPayException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Message submitRefund(PaymentRefundParam param) {
        log.debug("\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        WxPayRefundRequest request = new WxPayRefundRequest();
        try {
            BigDecimal multiple = new BigDecimal("100");
            BigDecimal totalFee = param.getPayOrder().getMoney().multiply(multiple);
            String outRefundNo = this.buildRefundOrderNo(param);
            BigDecimal refundFee = param.getFullAmount() != false ? totalFee : param.getRefundFee().multiply(multiple);
            request.setTransactionId(param.getPayOrder().getTradeNo());
            request.setOutRefundNo(outRefundNo);
            request.setTotalFee(Integer.valueOf(totalFee.intValue()));
            request.setRefundFee(Integer.valueOf(refundFee.intValue()));
            request.setOpUserId(this.wxH5PayService.getConfig().getMchId());
            request.setNotifyUrl(this.paymentProperties.getServerHost() + "/thirdparty/public/wechat/refund");
            request.checkAndSign(this.wxH5PayService.getConfig());
            WxPayRefundResult refundResult = this.wxH5PayService.refund(request);
            if (!StringUtils.equals((CharSequence)refundResult.getReturnCode(), (CharSequence)SUCCESS)) {
                log.error("\u9000\u6b3e\u7533\u8bf7\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)refundResult));
                return Message.build((boolean)false, (String)"\u5fae\u4fe1\u652f\u4ed8\u8c03\u7528\u5931\u8d25");
            }
            log.info("\u7533\u8bf7\u9000\u6b3e\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)refundResult));
            this.createRefundOrder(param, outRefundNo, refundFee.divide(multiple, RoundingMode.HALF_DOWN));
            log.debug("\u9000\u6b3e\u7533\u8bf7\u53d1\u8d77\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u503c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)refundResult));
        }
        catch (WxPayException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false, (String)"\u8c03\u7528\u5fae\u4fe1\u652f\u4ed8\u5e73\u53f0\u9000\u6b3eAPI\u5931\u8d25");
        }
        return Message.build((boolean)true);
    }
}

