/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.pay.wechat;

import com.bxm.fossicker.thirdpart.facade.dto.PaymentMpOrderDTO;
import com.bxm.fossicker.thirdpart.facade.dto.WxUserInfo;
import com.bxm.fossicker.thirdpart.facade.enums.PayTypeEnum;
import com.bxm.fossicker.thirdpart.facade.param.UserPayOrderInfoContext;
import com.bxm.fossicker.thirdpart.facade.service.WxMpAuthFacadeService;
import com.bxm.fossicker.thirdparty.service.impl.pay.wechat.AbstractWechatPaymentService;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatJsPaymentServiceImpl
extends AbstractWechatPaymentService<PaymentMpOrderDTO> {
    private static final Logger log = LoggerFactory.getLogger(WechatJsPaymentServiceImpl.class);
    private final WxMpAuthFacadeService wxMpAuthFacadeService;

    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.WX_JS_API_PAY;
    }

    @Override
    public PaymentMpOrderDTO create(UserPayOrderInfoContext paymentOrderDetail) {
        WxPayMpOrderResult result = this.createOrder(paymentOrderDetail);
        PaymentMpOrderDTO paymentMpOrderDTO = null;
        if (result != null) {
            paymentMpOrderDTO = new PaymentMpOrderDTO();
            paymentMpOrderDTO.setAppId(result.getAppId());
            paymentMpOrderDTO.setNonceStr(result.getNonceStr());
            paymentMpOrderDTO.setPackageValue(result.getPackageValue());
            paymentMpOrderDTO.setPaySign(result.getPaySign());
            paymentMpOrderDTO.setSignType(result.getSignType());
            paymentMpOrderDTO.setTimeStamp(result.getTimeStamp());
            paymentMpOrderDTO.setOrderNo(paymentOrderDetail.getOrderNo());
            if (this.wxH5PayService.getConfig() != null) {
                paymentMpOrderDTO.setMchId(this.wxH5PayService.getConfig().getMchId());
            }
        }
        return paymentMpOrderDTO;
    }

    private WxPayMpOrderResult createOrder(UserPayOrderInfoContext paymentOrder) {
        try {
            WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
            wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
            wxPayUnifiedOrderRequest.setOutTradeNo(paymentOrder.getOrderNo());
            wxPayUnifiedOrderRequest.setBody("\u60e0\u597d\u7701\u7ec8\u8eab\u4f1a\u5458");
            wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)paymentOrder.getMoney().toString()));
            wxPayUnifiedOrderRequest.setSpbillCreateIp(paymentOrder.getClientIp());
            wxPayUnifiedOrderRequest.setTradeType("JSAPI");
            WxUserInfo wxUserInfo = this.wxMpAuthFacadeService.getUserByCode2(paymentOrder.getCode());
            if (wxUserInfo.getOpenId() == null) {
                log.error("\u5fae\u4fe1\u6388\u6743\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0ccode\u4e3a\uff1a[{}]", (Object)paymentOrder.getCode());
            }
            wxPayUnifiedOrderRequest.setOpenid(wxUserInfo.getOpenId());
            return (WxPayMpOrderResult)this.wxH5PayService.createOrder(wxPayUnifiedOrderRequest);
        }
        catch (WxPayException e) {
            log.error("\u5fae\u4fe1\u4e0b\u5355\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{}", (Object)paymentOrder.getOrderNo(), (Object)e.getMessage());
            log.error("\u4e0b\u5355\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    @Autowired
    public WechatJsPaymentServiceImpl(WxMpAuthFacadeService wxMpAuthFacadeService) {
        this.wxMpAuthFacadeService = wxMpAuthFacadeService;
    }
}

