/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.pay.wechat;

import com.bxm.fossicker.thirdpart.facade.dto.PaymentOrderDTO;
import com.bxm.fossicker.thirdpart.facade.enums.PayTypeEnum;
import com.bxm.fossicker.thirdpart.facade.param.UserPayOrderInfoContext;
import com.bxm.fossicker.thirdparty.service.impl.pay.wechat.AbstractWechatPaymentService;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatPaymentServiceImpl
extends AbstractWechatPaymentService<PaymentOrderDTO> {
    private static final Logger log = LoggerFactory.getLogger(WechatPaymentServiceImpl.class);

    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.WX_PAY;
    }

    @Override
    public PaymentOrderDTO create(UserPayOrderInfoContext paymentOrderDetail) {
        WxPayMwebOrderResult result = this.createOrder(paymentOrderDetail);
        if (Objects.nonNull(result)) {
            paymentOrderDetail.setLink(result.getMwebUrl());
            PaymentOrderDTO order = new PaymentOrderDTO(paymentOrderDetail.getLink(), paymentOrderDetail.getOrderNo());
            if (this.wxH5PayService.getConfig() != null) {
                order.setMchId(this.wxH5PayService.getConfig().getMchId());
            }
            return order;
        }
        return null;
    }

    private WxPayMwebOrderResult createOrder(UserPayOrderInfoContext paymentOrder) {
        try {
            WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
            wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
            wxPayUnifiedOrderRequest.setOutTradeNo(paymentOrder.getOrderNo());
            wxPayUnifiedOrderRequest.setBody("\u60e0\u597d\u7701\u7ec8\u8eab\u4f1a\u5458");
            wxPayUnifiedOrderRequest.setSceneInfo("{\"h5_info\": {\"type\":\"Wap\",\"wap_url\": \"https://web.91huola.com/h5/fossicker\",\"wap_name\": \"\u60e0\u597d\u7701\u652f\u4ed8\"}}");
            wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)paymentOrder.getMoney().toString()));
            wxPayUnifiedOrderRequest.setSpbillCreateIp(paymentOrder.getClientIp());
            return (WxPayMwebOrderResult)this.wxH5PayService.createOrder(wxPayUnifiedOrderRequest);
        }
        catch (WxPayException e) {
            log.error("\u5fae\u4fe1\u4e0b\u5355\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{}", (Object)paymentOrder.getOrderNo(), (Object)e.getMessage());
            log.error("\u4e0b\u5355\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    @Autowired
    public WechatPaymentServiceImpl() {
    }
}

