/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.service.impl.pay.wechat;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.thirdpart.facade.dto.BaseWithdrawDTO;
import com.bxm.fossicker.thirdpart.facade.dto.WechatWithdrawDTO;
import com.bxm.fossicker.thirdpart.facade.enums.WithdrawChannelEnum;
import com.bxm.fossicker.thirdpart.facade.param.WithdrawParam;
import com.bxm.fossicker.thirdparty.config.WxPayProperties;
import com.bxm.fossicker.thirdparty.service.WithdrawService;
import com.bxm.fossicker.thirdparty.service.impl.pay.wechat.WechatWithdrawProxyService;
import com.bxm.fossicker.thirdparty.service.impl.pay.wechat.bo.WxWithdrawResult;
import com.bxm.fossicker.thirdparty.service.impl.pay.wechat.param.WxPayWithdrawRequest;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WechatWithdrawService
implements WithdrawService {
    protected static final Logger logger = LoggerFactory.getLogger(WechatWithdrawService.class);
    @Autowired
    private WechatWithdrawProxyService wechatWithdrawProxyService;
    @Autowired
    private WxPayProperties wxPayProperties;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private VipFacadeService vipFacadeService;
    private static final String SUCCESS = "SUCCESS";
    private static final String V2_ACCOUNT_SIMPLE_BAN = "V2_ACCOUNT_SIMPLE_BAN";
    @Value(value="${withdraw.switch}")
    private Boolean withdrawSwitch = Boolean.FALSE;

    @Override
    public WithdrawChannelEnum support() {
        return WithdrawChannelEnum.WX_WITHDRAW;
    }

    @Override
    public BaseWithdrawDTO withdraw(WithdrawParam withdrawFlow) {
        logger.info("\u63d0\u73b0\u7528\u6237[{}]\u7684\u63d0\u73b0\u8d26\u53f7\u4e3a\uff1a[{}]\uff0c\u63d0\u73b0\u91d1\u989d\u4e3a\uff1a[{}]", new Object[]{withdrawFlow.getUserId(), withdrawFlow.getPayAccount(), withdrawFlow.getAmount()});
        if (!this.withdrawSwitch.booleanValue()) {
            logger.info("\u63d0\u73b0\u5173\u95ed\uff0c\u8df3\u8fc7\u63d0\u73b0");
            WechatWithdrawDTO result = WechatWithdrawDTO.builder().build();
            result.setSucceed(Boolean.valueOf(true));
            result.setDeviceInfo(withdrawFlow.getEquipment());
            result.setMchAppId("withdraw switch closed");
            result.setPartnerTradeNo("withdraw switch closed");
            result.setPaymentNo("withdraw switch closed");
            result.setPaymentTime(DateUtils.getCurrentDateTime());
            result.setResultStr("withdraw switch closed");
            return result;
        }
        String requestId = this.sequenceCreater.nextLongId().toString();
        String key = withdrawFlow.getUserId() + withdrawFlow.getOrderNo();
        if (this.distributedLock.lock(key, requestId)) {
            WechatWithdrawDTO result = this.doWechatWithdraw(withdrawFlow);
            this.distributedLock.unlock(key, requestId);
            return result;
        }
        WechatWithdrawDTO result = WechatWithdrawDTO.builder().build();
        result.setErrorMsg("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
        result.setSucceed(Boolean.valueOf(false));
        return result;
    }

    private WechatWithdrawDTO doWechatWithdraw(WithdrawParam withdrawFlow) {
        WechatWithdrawDTO result = WechatWithdrawDTO.builder().build();
        WxPayWithdrawRequest wxPayWithdrawRequest = this.generateWithdraw(withdrawFlow);
        try {
            WxWithdrawResult wxWithdrawResult = this.wechatWithdrawProxyService.transfers(wxPayWithdrawRequest, withdrawFlow.getWithdrawClientType());
            logger.info("\u5fae\u4fe1\u8fd4\u56de\u4fe1\u606f[{}]", (Object)JSON.toJSONString((Object)((Object)wxWithdrawResult)));
            if (!SUCCESS.equals(wxWithdrawResult.getReturnCode()) || !SUCCESS.equals(wxWithdrawResult.getResultCode())) {
                result.setSucceed(Boolean.valueOf(false));
                if (V2_ACCOUNT_SIMPLE_BAN.equals(wxWithdrawResult.getErrCode())) {
                    logger.warn("\u8be5\u7528\u6237[{}]\u7684\u5fae\u4fe1\u672a\u5b9e\u540d\u8ba4\u8bc1", (Object)withdrawFlow.getUserId());
                    result.setErrorMsg("\u5fae\u4fe1\u672a\u5b9e\u540d\u8ba4\u8bc1");
                } else {
                    result.setErrorMsg(wxWithdrawResult.getReturnMsg());
                }
            } else {
                logger.info("\u7528\u6237[{}]\u63d0\u73b0\u6210\u529f\uff0c\u91d1\u989d\u4e3a\uff1a[{}]", (Object)withdrawFlow.getUserId(), (Object)withdrawFlow.getAmount());
                result.setSucceed(Boolean.valueOf(true));
                result.setDeviceInfo(wxWithdrawResult.getDeviceInfo());
                result.setMchAppId(wxWithdrawResult.getAppid());
                result.setPartnerTradeNo(wxWithdrawResult.getPartnerTradeNo());
                result.setPaymentNo(wxWithdrawResult.getPaymentNo());
                result.setPaymentTime(wxWithdrawResult.getPaymentTime());
            }
            result.setResultStr(JSON.toJSONString((Object)((Object)wxWithdrawResult)));
            return result;
        }
        catch (WxPayException e) {
            logger.error("\u7528\u6237[{}]\u63d0\u73b0\u91d1\u989d\u4e3a[{}]\u53d1\u751f\u9519\u8bef\uff1a[{}]", new Object[]{withdrawFlow.getUserId(), withdrawFlow.getAmount(), e.getMessage()});
            logger.error("\u5fae\u4fe1\u63d0\u73b0\u53d1\u751f\u9519\u8bef", (Throwable)e);
            result.setErrorMsg("\u63d0\u73b0\u53d1\u751f\u5f02\u5e38");
            result.setSucceed(Boolean.valueOf(false));
            return result;
        }
    }

    private WxPayWithdrawRequest generateWithdraw(WithdrawParam withdrawFlow) {
        WxPayWithdrawRequest wxPayWithdrawRequest = new WxPayWithdrawRequest();
        if (withdrawFlow.getWithdrawClientType() == null || withdrawFlow.getWithdrawClientType().intValue() == 1) {
            wxPayWithdrawRequest.setAppid(this.wxPayProperties.getAppId());
        } else {
            wxPayWithdrawRequest.setAppid(this.wxPayProperties.getAppletAppId());
        }
        wxPayWithdrawRequest.setOpenId(withdrawFlow.getPayAccount());
        wxPayWithdrawRequest.setAmount(BaseWxPayRequest.yuanToFen((String)withdrawFlow.getAmount().toString()));
        wxPayWithdrawRequest.setCheckName("NO_CHECK");
        wxPayWithdrawRequest.setDesc(this.wxPayProperties.getDesc());
        wxPayWithdrawRequest.setPartnerTradeNo(withdrawFlow.getOrderNo());
        wxPayWithdrawRequest.setSpbillCreateIp(withdrawFlow.getClientIp());
        return wxPayWithdrawRequest;
    }
}

