package com.bxm.fossicker.user.domain;

import com.bxm.fossicker.user.model.entity.UserAuthBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserAuthMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserAuthBean record);

    int insertSelective(UserAuthBean record);

    UserAuthBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserAuthBean record);

    int updateByPrimaryKey(UserAuthBean record);

    UserAuthBean selectByType(@Param("type") String type, @Param("token") String token);


    /**
     * 根据用户id 获取对应的type的信息
     * @param type
     * @param userId
     * @return
     */
    UserAuthBean selectByTypeAndUserId(@Param("type") String type, @Param("userId") Long userId);

    /**
     * 根据用户id 列表获取对应的type的信息
     * @param type
     * @param userIds
     * @return
     */
    List<UserAuthBean> selectByTypeAndUserIds(@Param("type") String type, @Param("userIds") List<Long> userIds);

    /**
     * 根据用户uid查询用户认证信息
     * @param uid 微信id
     * @return 用户认证信息
     */
    Long selectUserIdByUid(String uid);

    int deleteByUserId(Long userId);

    int fixErrorMuteAuth(@Param("muteUserId") Long muteUserId, @Param("normalUserId")Long normalUserId);
}