package com.bxm.fossicker.user.domain;

import com.bxm.fossicker.user.model.entity.UserCashFlowBean;
import com.bxm.fossicker.user.model.param.FlowPageParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

@Mapper
public interface UserCashFlowMapper {

    int deleteByPrimaryKey(Long id);

    int insert(UserCashFlowBean record);

    int insertSelective(UserCashFlowBean record);

    UserCashFlowBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserCashFlowBean record);

    int updateByPrimaryKey(UserCashFlowBean record);

    UserCashFlowBean getLastCashFlow(@Param("userId") Long userId,@Param("type") String type);

    List<UserCashFlowBean> listUserCashFlow(FlowPageParam param);

    List<UserCashFlowBean> listUserCashFlowByType(@Param("userId") Long userId, @Param("relationId") Long relationId);

    /**
     * 订单明细金额增加
     *
     * @param userId
     * @param id
     * @return
     */
    int updateIncrementAmount(@Param("userId")Long userId,@Param("id")Long id,@Param("amount") BigDecimal amount);
}