package com.bxm.fossicker.user.domain;

import com.bxm.fossicker.user.model.entity.UserInfoBean;
import com.bxm.fossicker.user.model.entity.UserInviteNumBean;
import com.bxm.fossicker.user.model.param.BindPhoneParam;
import com.bxm.fossicker.user.model.param.BindPushTokenParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserInfoMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserInfoBean record);

    int insertSelective(UserInfoBean record);

    UserInfoBean selectByPrimaryKey(Long id);

    UserInfoBean selectByPhone(String phone);

    /**
     * 根据邀请码查询用户信息
     *
     * @param inviteCode 邀请码
     * @return 用户信息
     */
    UserInfoBean selectByInviteCode(String inviteCode);

    /**
     * 查询静默用户
     *
     * @param userId 静默用户ID
     * @return 用户信息
     */
    UserInfoBean selectMutedUser(Long userId);

    List<Long> listIdBySuperiorUserId(Long superiorUserId);

    /**
     * 通过淘宝客会员id查询用户
     *
     * @param specialId 淘宝客会员id
     */
    UserInfoBean selectBySpecialId(String specialId);

    /**
     * 通过淘宝客渠道id查询用户
     *
     * @param relationId 淘宝客渠道id
     */
    UserInfoBean selectByRelationId(String relationId);

    int updateByPrimaryKeySelective(UserInfoBean record);

    /**
     * 更新手机号码
     *
     * @param param 更新参数
     * @return 更新影响行数
     */
    int updatePhone(BindPhoneParam param);

    /**
     * 更新用户的推送token
     *
     * @param param 更新参数
     * @return 更新影响行数
     */
    int updatePushToken(BindPushTokenParam param);

    /**
     * 更新用户的上级用户和顶级用户
     *
     * @param entity 用户信息
     * @return 更新影响行数
     */
    int updateParentId(UserInfoBean entity);

    /**
     * 绑定淘宝会员信息
     *
     * @param userId
     * @param relationId 淘宝渠道ID
     * @param specialId  淘宝会员ID
     * @return
     */
    int updateSetTBrelation(@Param("id") Long userId, @Param("tbRelationId") String relationId, @Param("tbSpecialId")
            String specialId);

    /**
     * 更新用户绑定的设备ID
     *
     * @param id          用户ID
     * @param equipmentId 设备ID
     * @return 更新影响行数
     */
    int updateEquipment(@Param("id") Long id, @Param("equipmentId") Long equipmentId);

    /**
     * 根据设备编号ID获取最后一条用户信息
     *
     * @param equipmentId 设备ID
     * @return 用户ID
     */
    Long selectByEquipmentId(Long equipmentId);

    /**
     * 获取判断标记
     *
     * @param userId 用户ID
     * @return 用户的判断标记
     */
    Long getJudgeMarker(Long userId);

    /**
     * 根据手机号查询用户且用户状态为1
     *
     * @param phone 手机号
     * @return 用户信息
     */
    UserInfoBean selectByPhoneValid(String phone);

    /**
     * 更改会员状态 0：非会员  1：会员
     *
     * @param userId
     * @param status
     * @return
     */
    int updateVipStatus(@Param("userId") Long userId, @Param("status") int status);

    /**
     * 通过用户ID获取设备号
     *
     * @param userId 用户id
     * @return 用户设备号
     */
    Long getEquipmentbyUserId(Long userId);

    /**
     * 获取用户收徒的情况
     *
     * @return
     */
    List<UserInviteNumBean> getUserInviteInfo();

    /**
     * 获取老邀请关系用户列表-状态为2,上级id不为空
     *
     * @return 用户list
     */
    List<UserInfoBean> getOldRelationUser();

    /**
     * 获取错误的静默用户信息
     *
     * @return 错误的静默用户信息list
     */
    List<UserInfoBean> selectMuteErrorUser();

    /**
     * 根据设备id查询正常用户
     *
     * @param equipmentId 设备id
     * @return 查询的用户信息
     */
    UserInfoBean selectNormalUserByEquipmentId(Long equipmentId);

    /**
     * 修复错误信息 user表中各类信息
     *
     * @param userId 用户id
     * @return 修复结果
     */
    Integer fixErrorMuteUser(Long userId);

    /**
     * @param equipmentId
     * @return
     */
    List<UserInfoBean> listByEquipmentId(String equipmentId);
}