package com.bxm.fossicker.user.domain;

import java.util.List;

import com.bxm.fossicker.user.model.entity.UserPayorderInfoBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;


@Mapper
public interface UserPayorderInfoMapper {
    /**
     * 获取用户购买订单信息
     * @param userId
     * @return
     */
    List<UserPayorderInfoBean> getList(@Param("userId") Long userId);
    /**
     * 获取所有超时订单信息
     * @param  minute 超时限制,分钟
     */
    List<UserPayorderInfoBean> getTimeoutList(int minute);



    /**
     * 订单状态更新
     * @return
     */
    int updateStatus(@Param("orderNo") String orderNo,@Param("status") Byte status,@Param("tradeNo")String tradeNo);
    /**
     * 订单状态批量更新
     * @return
     */
    int updateStatusBatch(@Param("orderNos") List<String> orderNos,@Param("status") Byte status);
    /**
     * 订单号获取订单信息
     * @param orderNo
     * @return
     */
    UserPayorderInfoBean getDetailByOrderNo(@Param("userId") Long userId, @Param("orderNo") String orderNo);

    int deleteByPrimaryKey(UserPayorderInfoBean id);

    int insert(UserPayorderInfoBean record);

    int insertSelective(UserPayorderInfoBean record);

    UserPayorderInfoBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserPayorderInfoBean record);

    int updateByPrimaryKey(UserPayorderInfoBean record);

    /**
     * 获取超时订单号
     * @param time-规定超时时间
     * @return
     */
    List<String> getTimeoutOrder(@Param("times") Integer time);
}