package com.bxm.fossicker.user.domain;

import com.bxm.fossicker.user.model.entity.UserPreRegBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface UserPreRegMapper {
    int deleteByPrimaryKey(Long id);

    int insert(UserPreRegBean record);

    int insertSelective(UserPreRegBean record);

    UserPreRegBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(UserPreRegBean record);

    int updateByPrimaryKey(UserPreRegBean record);

    /**
     * 根据唯一ID更新用户ID
     * @param identify 唯一ID
     * @param userId   绑定的用户ID
     * @return 更新影响行数
     */
    int updateByIdentify(@Param("identify") String identify, @Param("userId") Long userId);

    /**
     * 根据唯一值查询用户预注册信息
     * @param identify 唯一值
     * @return 预注册信息
     */
    UserPreRegBean selectByIdentify(String identify);

    /**
     * 更新用户邀请信息
     * @param record 更新参数
     * @return 更新结果
     */
    int updateInviteInfo(UserPreRegBean record);
}