package com.bxm.fossicker.user.domain;

import com.bxm.fossicker.user.model.entity.VipRecordBean;
import com.bxm.fossicker.user.model.entity.VipUserInfoBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2019/11/19 14:17
 */
@Mapper
public interface VipUserInfoMapper {

    int insertSelective(VipUserInfoBean record);

    int update(VipUserInfoBean record);

    VipUserInfoBean selectByUserId(Long userId);

    /**
     * 固化月卡记录信息
     * @param vipRecordBean
     * @return
     */
    int insertVipRecord(VipRecordBean vipRecordBean);

    List<VipRecordBean> vipRecordInfoByUserId(@Param("userId") Long userId);

    List<VipUserInfoBean> vipUserInfoByStatus(@Param("status") int status);

    /**
     * 根据用户id获取邀请得到的月卡数
     * @param userId 用户id
     * @return 月卡数
     */
    Integer getVipCardByInvite(Long userId);

    /**
     * 根据用户id获取得到所有vip卡
     * @param userId 用户id
     * @return 月卡数
     */
    Integer getTotalVipCard(Long userId);
}
