package com.bxm.fossicker.user.facade;

import com.bxm.fossicker.user.facade.param.*;
import com.bxm.fossicker.user.model.dto.AccountDetailDto;
import com.bxm.newidea.component.vo.Message;

/**
 * Created by Gonzo on 2019-07-08.
 */
public interface AccountFacadeService {

    /**
     * 佣金拟结算
     * @param param 结算参数
     * @return 处理信息
     */
    Message commissionDraft(CommissionDraftParam param);

    /**
     * 佣金取消结算
     * @param param
     * @return 处理信息
     */
    Message commissionCancel(CommissionCancelParam param);

    /**
     * 佣金结算
     * @param param
     * @return 处理信息
     */
    Message commissionRebate(CommissionRebateParam param);

    /**
     * 外卖佣金拟结算
     * @param param 结算参数
     * @return 处理信息
     */
    Message takeOutCommissionDraft(CommissionDraftParam param);

    /**
     * 外卖佣金取消结算
     * @param param
     * @return 处理信息
     */
    Message takeOutCommissionCancel(CommissionCancelParam param);

    /**
     * 外卖佣金结算
     * @param param
     * @return 处理信息
     */
    Message takeOutCommissionRebate(CommissionRebateParam param);

    /**
     * 金币结算
     * @param param
     * @return
     */
    Message goldRebate(GoldRebateParam param);

    /**
     * 消费金币
     * @param param param
     * @return 处理信息
     */
    Message subtractGoldRebate(GoldRebateParam param);

    /**
     * 获取用户账号详情
     * @param userId 用户ID
     * @return 用户账号详情
     */
    AccountDetailDto loadAccountDetail(Long userId);

    /**
     * 增加现金
     * @param cashIncrementParam 参数
     * @return 处理信息
     */
    Message cashIncrement(CashIncrementParam cashIncrementParam);
}
