package com.bxm.fossicker.user.facade;

import com.bxm.fossicker.user.facade.dto.*;
import com.bxm.fossicker.user.model.entity.UserAuthBean;
import com.bxm.fossicker.vo.BasicParam;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * 用户facade服务
 *
 * @author zhaoxin
 **/
public interface UserInfoFacadeService {

    /**
     * 通过id获取用户信息
     *
     * @param userId 用户id
     * @return 用户信息
     */
    UserInfoDto getUserById(Long userId);

    /**
     * 淘宝客渠道id
     */
    String getTbkRelationId(Long userId);

    /**
     * 通过id列表获取用户信息
     *
     * @param userIdList 用户id
     * @return 用户信息
     */
    List<UserInfoDto> getUserByIds(List<Long> userIdList);

    /**
     * 根据邀请码或者手机号获取
     *
     * @param code 邀请码或手机号
     * @return 用户信息
     */
    UserInfoDto getUserByInviteCodeOrPhone(String code);

    /**
     * 设置上级用户和顶级用户
     *
     * @param userId     用户id
     * @param superiorId 上级用户id
     * @return 设置结果
     */
    Boolean setSuperior(Long userId, Long superiorId);

    /**
     * 获取用户的上级用户和顶级用户
     *
     * @param specialId 会员id
     * @return 用户上级和顶级用户信息
     */
    SuperiorDto getSuperiorBySpecialId(String specialId);

    /**
     * 根据relationId获取用户的上级用户和顶级用户
     *
     * @param relationId relationId
     * @return 用户上级和顶级用户信息
     */
    SuperiorDto getSuperiorByRelationId(String relationId);

    /**
     * 根据用户id获取上级用户信息
     *
     * @param userId
     * @return
     */
    SuperiorDto getSuperiorByUserId(Long userId);

    /**
     * 领取完新手礼包之后调用
     * 修改是否领取新手礼包的状态
     *
     * @param userId 用户ID
     */
    void claimedPacket(Long userId);

    /**
     * 是否是新用户
     * 定义：第一次登录app，且当天这个时间都是新用户
     *
     * @param userId
     * @return
     */
    Boolean isNoviceUser(Long userId);

    /**
     * 根据设备创建静默用户
     * 如果设备存在对应的用户，则返回用户ID
     * 如果不存在则创建静默用户，并返回其ID
     *
     * @param equipmentId 设备ID
     * @param param       基础参数
     * @return 静默用户ID
     */
    Long createMutedUser(Long equipmentId, BasicParam param);

    /**
     * 根据uid获取用户id
     *
     * @param uid 微信uid
     * @return 用户id
     */
    Long getUserIdByUid(String uid);

    /**
     * 通过手机号获取用户信息
     *
     * @param phone 手机号
     * @return 用户信息
     */
    UserInfoDto getUserForPhone(String phone);

    /**
     * 通过用户ID获取设备号
     *
     * @param userId
     * @return 用户设备号
     */
    Long getEquipmentByUserId(Long userId);

    /**
     * 获取第一次登录信息
     *
     * @param userId
     * @return
     */
    UserLoginHistoryDTO getFirstLoginInfo(Long userId);

    /**
     * 获取最后一次登录信息
     *
     * @param userId
     * @return
     */
    UserLoginHistoryDTO getLastLoginInfo(Long userId);

    /**
     * 获取所有用户的收徒情况
     *
     * @return
     */
    List<UserInviteNumDTO> getAllInfoInviteNum();

    List<UserInfoDto> getOldRelationUser();

    /**
     * 已经绑定淘宝
     *
     * @param userId
     * @return true=是
     */
    Boolean hasBindTaobao(Long userId);

    /**
     * 校验设备是否符合邀请用户的策略
     * 1. 设备除了当前用户未绑定过其他人
     * 2. 设备号存在于设备表中 除了0
     *
     * @param userId   用户id
     * @param deviceId 设备id
     * @return
     */
    Message deviceCheckFromInvite(Long userId, String deviceId);

    /**
     * 获取用户的注册天数
     * 满足一个自然天(24h) 才为1
     *
     * @param userId userId
     * @return 注册的天数
     */
    int getRegisterDays(Long userId);

    /**
     * 根据用户id 列表获取对应的type的信息
     *
     * @param type
     * @param userId
     * @return
     */
    List<UserAuthBean> selectByTypeAndUserIds(String type, List<Long> userId);

    /**
     * 根据用户id获取邀请信息
     *
     * @param userId
     * @return
     */
    InviteInfoDTO getInviteInfoByUserId(Long userId);

    /**
     * 检测是否是特殊渠道
     *
     * @param regChannel
     * @return
     */
    Boolean checkIsSpecialRegChannel(String regChannel);
}
