/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.fossicker.user.facade;

import com.bxm.fossicker.user.facade.dto.PayorderInfoConfigDTO;
import com.bxm.fossicker.user.facade.dto.PayorderInfoDTO;

import java.util.List;

/**
 * @Author:jieli.xu
 * @Created: 2019/11/18
 * @Modifier:jieli.xu
 * @Updated:2019/11/18
 * @Description: 对外提供订单配置信息
 * @Version:BUILD1001
 */
public interface UserPayorderInfoFacadeService {
    /**
     * 获取用户订单配置信息价格
     * @param type
     * @return
     */
    PayorderInfoConfigDTO getMoneyInfo(Integer type);

    /**
     * 第三方服务-更新订单状态
     * @param orderNo 商户订单号
     * @param status 状态
     * @param tradeNo 微信订单号
     * @return
     */
    Boolean updateOrderInfo(String orderNo,Byte status,String tradeNo);

    /**
     * 返回订单支付状态【微信、支付宝】
     * @param orderNo
     * @param userId
     * @return
     */
    String getWxOrderStatus(String orderNo,  Long userId);

    /**
     * 获取支付订单超时的任务信息
     *
     * @return
     */
    List<String> getTimeOutIds();

    /**
     * 更新订单状态
     * @param orderNos
     * @param status
     * @return
     */
    int updateStatusBatch(List<String> orderNos, Byte status);

    /**
     *
     */
    PayorderInfoDTO getByOrderNo(String orderNo);
}
