package com.bxm.fossicker.user.facade;

import com.bxm.fossicker.user.model.entity.WxOfficialAccount;
import com.bxm.fossicker.user.model.entity.WxOfficialLog;

import java.util.List;

public interface WxOfficialAccountFacadeService {

    /**
     * 关注公众号
     * @param openId 用户微信oid
     * @param uid 用户微信uid
     * @param userId 用户id
     * @param status 1-关注,0-取消关注
     * @return
     */
    boolean focusOnOfficialAccount(String openId, String uid, Long userId, Integer status);

    /**
     * 记录微信回调事件日志
     * @param wxOfficialLog
     */
    void saveLog(WxOfficialLog wxOfficialLog);

    /**
     * 根据用户id 列表获取对应的微信相关信息
     * @param userId
     * @return
     */
    List<WxOfficialAccount> selectByUserIds(List<Long> userId);
}
