package com.bxm.fossicker.user.facade.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

@Data
@Builder
public class UserAuthDTO {

    @Tolerate
    public UserAuthDTO() {
    }

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 鉴权类型(微信oid、一键登录、微信uid、手机号码、淘宝授权)
     */
    private String authType;

    /**
     * 鉴权类型对应的token
     */
    private String token;

    /**
     * 鉴权凭证（密码）
     */
    private String credential;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;
}
