package com.bxm.fossicker.user.facade.dto;


import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * @ClassName UserInfoDto
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/7/2 12:50
 * @Version 1.0.0
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
@Builder
public class UserInfoDto extends BaseBean {
    /**
     * 主键
     */
    private Long id;

    /**
     * 用户昵称
     */
    private String nickName;

    /**
     * 用户头像
     */
    private String headImg;

    /**
     * 手机号码
     */
    private String phoneno;

    /**
     * 邀请码
     */
    private String inviteCode;

    /**
     * 直接上级用户
     */
    private Long superiorUserId;

    /**
     * 上上级（顶级用户）
     */
    private Long topUserId;

    /**
     * 用户角色 1：学生党|2：上班族|3：奶爸|4：爷爷|5：宝妈：6：奶奶
     */
    private Byte character;

    /**
     * 用户性别(1:男，2：女，0:未知)
     */
    private Byte sex;

    /**
     * 是否领取过新人礼包
     */
    private Boolean claimedPacket;

    /**
     * 最后登录时的设备ID
     */
    private Long equipment;

    @ApiModelProperty("微信账号昵称")
    private String wechatNickName;

    @ApiModelProperty("淘宝账号昵称")
    private String taobaoNickName;

    /**
     * 判断标记，每一个bit位代表一种boolean值
     * @see com.bxm.fossicker.enums.UserJudgeMarkerEnum
     */
    private Long judgeMarker;
    /**
     * 注册时如与业务实体有关，填写业务ID
     */
    private Long relationId;

    /**
     * 创建时间
     */
    private Date createTime;

    @ApiModelProperty(value = "0:非会员  1：会员",hidden = true)
    private int vip;

    @ApiModelProperty(value = "注册渠道（通过何种渠道进行的用户注册）")
    private String regChannel;

}
