package com.bxm.fossicker.user.facade.enums;

/**
 * Created by Gonzo on 2019-07-11.
 * 现金业务类型
 * 每一个业务类型都会定义一个 账户流水变动类型 AccountFlowActionEnum
 * 和一个现金来源类型 cashTypeEnum
 */
public enum CashTransactionTypeEnum {

    /**
     * 佣金拟结算
     */
    COMMISSION_DRAFT("COMMISSION_DRAFT", "佣金拟结算", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.INCREMENT_CHECKING_CASH),

    COMMISSION_CANCEL("COMMISSION_CANCEL", "佣金取消结算", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.REDUCE_CHECKING_CASH),

    COMMISSION_REBATE("COMMISSION_REBATE", "佣金结算", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.CHECKING_CASH_TO_DRAWABLEL_CASH),

    /**
     * 佣金拟结算
     */
    TAKE_OUT_COMMISSION_DRAFT("TAKE_OUT_COMMISSION_DRAFT", "外卖佣金拟结算", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.INCREMENT_CHECKING_CASH_AND_TAKE_OUT_CASH),

    TAKE_OUT_COMMISSION_CANCEL("TAKE_OUT_COMMISSION_CANCEL", "外卖佣金取消结算", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.REDUCE_CHECKING_CASH_AND_TAKE_OUT_CASH),

    /**
     * 外卖佣金结算
     */
    TAKE_OUT_COMMISSION_REBATE("TAKE_OUT_COMMISSION_REBATE", "外卖佣金结算", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.CHECKING_CASH_TO_DRAWABLEL_CASH_AND_TAKEOUT_CASH),


    COMMISSION_WITHDRAW("COMMISSION_WITHDRAW", "佣金直接提现", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.DRAWABLEL_CASH_TO_WITHDRAWAL_CASH),

    COMMISSION_WITHDRAW_DRAFT("COMMISSION_WITHDRAW", "佣金拟提现", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.DRAWABLEL_CASH_TO_WITHDRAWING_CASH),

    COMMISSION_WITHDRAW_CONFIRM("COMMISSION_WITHDRAW_CONFIRM", "佣金拟提现确认通过", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.WITHDRAWING_CASH_TO_WITHDRAWAL_CASH),

    COMMISSION_WITHDRAW_REJECT("COMMISSION_WITHDRAW_REJECT", "佣金拟提现审核拒绝", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.WITHDRAWING_CASH_TO_DRAWABLEL_CASH),

    COMMISSION_REDPACKET_INCREMENT("COMMISSION_REDPACKET_INCREMENT", "增加红包奖励", CashTypeEnum.RED_PRICKET,
            AccountFlowActionEnum.INCREMENT_REDPACKET_CASH),

    COMMISSION_INVITE_INCREMENT("COMMISSION_INVITE_INCREMENT", "增加邀请奖励", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.INCREMENT_INVITED_CASH),

    COMMISSION_OTHER_INCREMENT("COMMISSION_OTHER_INCREMENT", "增加其他奖励", CashTypeEnum.COMMISSION,
            AccountFlowActionEnum.INCREMENT_OTHERINCOME_CASH),
    ;

    private String code;

    private String des;

    /**
     * 对应的现金来源类型
     */
    private CashTypeEnum cashTypeEnum;

    /**
     * 对应的账户流水变动处理类型
     */
    private AccountFlowActionEnum action;

    CashTransactionTypeEnum(String code, String des, CashTypeEnum cashTypeEnum, AccountFlowActionEnum action) {
        this.code = code;
        this.des = des;
        this.cashTypeEnum = cashTypeEnum;
        this.action = action;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    public CashTypeEnum getCashTypeEnum() {
        return cashTypeEnum;
    }

    public AccountFlowActionEnum getAction() {
        return action;
    }
}
