package com.bxm.fossicker.user.facade.enums;

/**
 * Created by Gonzo on 2019-07-11.
 * 金币业务类型
 * 每一个业务类型都对应一种 账户流水变动处理类型 AccountFlowActionEnum
 */
public enum GoldTransactionTypeEnum {

    /**
     *
     */
    GOLD_REBATE("GOLD_REBATE", "金币结算", AccountFlowActionEnum.INCREMENT_USABLE_GOLD),
    WATCH_VIDEO_GOLD_WITHDRAW("WATCH_VIDEO_GOLD_WITHDRAW", "看视频后金币立即提现", AccountFlowActionEnum.USABLE_GOLD_TO_CONSUME_GOLD),

    //1.4.1版本 视频自动提现
    GOLD_WITHDRAW_NEW_VIDEO("GOLD_WITHDRAW_NEW_VIDEO", "金币立即提现", AccountFlowActionEnum.USABLE_GOLD_TO_CONSUME_GOLD),

    GOLD_WITHDRAW_CONFIRM("GOLD_WITHDRAW_CONFIRM", "金币提现审批成功", AccountFlowActionEnum.WTIHDRAWING_GOLD_TO_CONSUME_GOLD),
    GOLD_WITHDRAW_REJECT("GOLD_WITHDRAW_REJECT", "金币提现审批失败", AccountFlowActionEnum.WTIHDRAWING_GOLD_TO_USABLE_GOLD),
    GOLD_WITHDRAW_DRAFT("GOLD_WITHDRAW_DRAFT", "老版本签到金币拟提现", AccountFlowActionEnum.USABLE_GOLD_TO_WTIHDRAWING_GOLD),

    NEW_GOLD_WITHDRAW_DRAFT("NEW_GOLD_WITHDRAW_DRAFT", "新版本金币拟提现", AccountFlowActionEnum.USABLE_GOLD_TO_WTIHDRAWING_GOLD),

    GOLD_SUBTRACT_AMOUNT("SUBTRACT_GOLD_AMOUNT", "消费金币余额", AccountFlowActionEnum.SUBTRACT_GOLD_AMOUNT),

    // V1.6.0 金币直接提现
    GOLD_WITHDRAW_RIGHT_NOW("GOLD_WITHDRAW_RIGHT_NOW", "金币秒到账", AccountFlowActionEnum.USABLE_GOLD_TO_CONSUME_GOLD),

    // V1.6.1 外卖金币直接提现
    TAKE_OUT_GOLD_WITHDRAW_RIGHT_NOW("TAKE_OUT_GOLD_WITHDRAW_RIGHT_NOW", "外卖金币秒到账", AccountFlowActionEnum.USABLE_GOLD_TO_CONSUME_GOLD);

    private String code;

    private String des;

    /**
     * 对应的账户流水变动处理类型
     */
    private AccountFlowActionEnum action;

    GoldTransactionTypeEnum(String code, String des, AccountFlowActionEnum action) {
        this.code = code;
        this.des = des;
        this.action = action;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    public AccountFlowActionEnum getAction() {
        return action;
    }

}
