package com.bxm.fossicker.user.facade.enums;

/**
 * Created by Gonzo on 2019-07-08.
 * 佣金流水明细类型
 */
public enum UserCashFlowTypeEnum {

    /**
     * 自购佣金结算
     */
    PURCHASED_COMMISSION_REBATE("PURCHASED_COMMISSION_REBATE", "自购佣金结算"),
    SHARED_COMMISSION_REBATE("SHARED_COMMISSION_REBATE", "分享佣金结算"),
    COMMUNITY_COMMISSION_REBATE("COMMUNITY_COMMISSION_REBATE", "好友佣金结算"),
    COMMISSION_WITHDRAWAL("COMMISSION_WITHDRAWAL", "佣金提现"),
    COMMISSION_WITHDRAWAL_REFUSE("COMMISSION_WITHDRAWAL_REFUSE", "提现失败"),
    WATCH_VIDEO_PACKET_CASH("WATCH_VIDEO_PACKET_CASH", "看视频返现红包"),
    VIP_DRAW_RED_PACKET_CASH("VIP_DRAW_RED_PACKET_CASH", "VIP抽奖红包"),
    USER_LOGIN_INVITE_CASH("USER_LOGIN_INVITE_CASH", "邀请好友登录奖励"),
    USER_VIP_INVITE_CASH("USER_VIP_INVITE_CASH", "邀请好友领取VIP奖励"),
    PLAY_GAME_OTHER_CASH("PLAY_GAME_OTHER_CASH", "试玩赚零花奖励"),
    FRIENDS_CASH_SHARE("FRIENDS_CASH_SHARE", "好友收入分成"),
    FRIENDS_CASH_OBTAIN_VIP("FRIENDS_CASH_OBTAIN_VIP", "邀请好友开通黑钻卡奖励"),
    TAKE_OUT_ORDER_COMMISSION_REBATE("TAKE_OUT_ORDER_COMMISSION_REBATE", "外卖补贴结算"),
    ;


    private String code;

    private String des;


    UserCashFlowTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public static String getDesByCode(String code) {
        UserCashFlowTypeEnum[] enums = UserCashFlowTypeEnum.values();

        for (UserCashFlowTypeEnum anEnum : enums) {
            if (anEnum.getCode().equals(code)) {
                return anEnum.getDes();
            }
        }

        return "";
    }


    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

}
