package com.bxm.fossicker.user.facade.enums;

/**
 * 用户类型枚举
 *
 * @author Gonzo
 * @date 2019-10-10 16:26
 */
public class UserTypeEn {

    /**
     * 新用户
     */
    public static final byte NOVICE = 1;
    /**
     * 老用户
     */
    public static final byte OLD = 2;
    /**
     * 未下单用户
     */
    public static final byte NOT_ORDER = 3;
    /**
     * 已下单用户
     */
    public static final byte ORDERED = 4;
    /**
     * 自定义用户id
     */
    public static final byte CUSTOM = 5;
    /**
     * 未开卡用户（未购买终身黑钻卡的用户）
     */
    public static final byte NOT_LIFELONG_VIP = 6;
    /**
     * 非会员用户（非终身会员和有有效期会员的用户）
     */
    public static final byte NOT_VIP = 7;
    /**
     * 会员用户：包括月卡在有效期内的用户以及领取黑钻卡的用户
     */
    public static final byte VIP = 8;
}
