package com.bxm.fossicker.user.facade.enums;

/**
 * 用户类型枚举
 *
 * @author Gonzo
 * @date 2019-10-10 16:26
 */
public enum VipTypeEnum {

    NOT_VIP((byte) 0, "非vip"),
    VIP_NOT_EXPIRED((byte) 1, "非终身vip未过期"),
    VIP_EXPIRED((byte) 2, "非终身vip已过期"),
    VIP_FOREVER((byte) 3, "终身vip"),
    ;

    private byte type;

    private String des;

    VipTypeEnum(byte type, String des) {
        this.type = type;
        this.des = des;
    }

    public int getType() {
        return type;
    }

    public String getDes() {
        return des;
    }

    /**
     * 判断是否是VIP
     *
     * @param vipFlag 用户的VIP标记字段
     * @return true表示用户是VIP
     */
    public static boolean isUsable(byte vipFlag) {
        return VIP_NOT_EXPIRED.getType() == vipFlag
                ||  VIP_FOREVER.getType() == vipFlag;
    }

}
