package com.bxm.fossicker.user.facade.param;

import com.bxm.fossicker.user.facade.enums.CashTypeDetail;
import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

/**
 * Created by jieli.xu
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class CashIncrementParam extends BaseBean {

    @Tolerate
    public CashIncrementParam() {
    }

    @ApiModelProperty(value = "userId", required = true)
    private Long userId;

    @ApiModelProperty(value = "交易金额 可正负 单位元", required = true)
    private BigDecimal amount;

    @ApiModelProperty(value = "业务id（如订单id）", required = true)
    private Long relationId;

    @ApiModelProperty("1-普通红包 2-膨胀红包 3-好友登录 4-好友领VIP 5-试玩赚零花奖励")
    private CashTypeDetail typeDetail;


    public CashIncrementParam(Long userId, BigDecimal amount, Long relationId, CashTypeDetail typeDetail) {
        this.userId = userId;
        this.amount = amount;
        this.relationId = relationId;
        this.typeDetail = typeDetail;
    }
}
