package com.bxm.fossicker.user.facade.param;

import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * Created by Gonzo on 2019-08-09.
 */
@Data
public class CommissionCancelParam {

    @ApiModelProperty(value = "佣金流水类型 自购佣金|分享佣金|社群佣金", required = true, example = "PURCHASED_COMMISSION_REBATE")
    private UserCashFlowTypeEnum cashFlowType;

    @ApiModelProperty(value = "userId", required = true)
    private Long userId;

    @ApiModelProperty(value = "交易金额 可正负 单位元", required = true)
    private BigDecimal amount;

    @ApiModelProperty(value = "业务id（如订单id）", required = true)
    private Long relationId;
}
