package com.bxm.fossicker.user.facade.param;

import com.bxm.fossicker.enums.UserGoldFlowTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

/**
 * Created by Gonzo on 2019-08-09.
 */
@Data
@Builder
public class GoldRebateParam {

    @ApiModelProperty(value = "金币流水类型", required = true, example = "INPUT_INVITE")
    private UserGoldFlowTypeEnum userGoldFlowType;

    @ApiModelProperty(value = "userId", required = true)
    private Long userId;

    @ApiModelProperty(value = "交易金额 可正负", required = true)
    private BigDecimal amount;

    @ApiModelProperty(value = "业务id（如订单id）", required = true)
    private Long relationId;

    @Tolerate
    public GoldRebateParam() {
    }
}
