package com.bxm.fossicker.user.facade.vip;

import com.bxm.fossicker.user.facade.dto.TobeVipInviteSpeedDto;
import com.bxm.fossicker.user.facade.param.TobeVipParam;

import java.math.BigDecimal;

/**
 * @Author: pf.w
 * @Date: 2019/11/19 9:45
 */

public interface VipFacadeService {

    /**
     * 是否会员
     * @param userId
     * @return  true 是  false 否
     */
    boolean isVip(Long userId);

    /**
     * vip 自否返现比例
     * @return
     */
    String vipPurchase();

    /**
     * tobe   VIP 废弃【1.6.0一改版】
     * @return
     */
    @Deprecated
    boolean tobeVip(TobeVipParam param);

    /**
     * 成为终身会员
     * tobe VIP【1.6.0一改版】
     * @return
     */
    boolean tobeVipForV2(TobeVipParam param);

    /**
     * 根据用户id获取vip状态  0：非vip 1：非终身vip未过期  2：非终身vip已过期 3：终身vip
     * @param userId
     * @return
     */
    Byte getVipStatus(Long userId);

    /**
     * tobe   VIP  for WEICAI 微财  (公司内部年卡)
     * @return
     */
    boolean tobeVipForWc(TobeVipParam param);

    /**
     * 获取邀请得到的月卡张数
     * @param userId 用户id
     * @return 月卡张数
     */
    Integer getVipCardByInvite(Long userId);

    Integer getTotalVipCard(Long userId);

    /**
     * 计入会员多返金额
     * @param userId
     * @param commission
     * @param type  1：增加  0 ：扣除
     * @return
     */
    boolean addVipCommission(Long userId, BigDecimal commission,int type);

    /**
     * 检查会员是否过期
     */
    void checkVipExpired();

    /**
     * 手动置为会员失效
     * @param userId
     */
    void invalidVip(Long userId);

    Integer pushTobeVipContent(Long userId);

    Integer pushTobeForeverVipContent(Long userId);

    boolean removeTobeVipPush(Long userId);

    boolean removeTobeForeverVipPush(Long userId);

    /**
     * 组装邀请会员进度弹窗所需要的附带参数
     * @param userId
     * @return
     */
    TobeVipInviteSpeedDto inviteVipEntity(Long userId);
}
