package com.bxm.fossicker.user.model.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@ApiModel(description = "账户聚合信息，包括用户详情，账户金币、现金余额信息等")
@Data
@EqualsAndHashCode(callSuper = true)
public class AccountAggregateDto extends BaseBean {

    @ApiModelProperty("用户详情")
    private UserDetailDto userDetail;

    @ApiModelProperty("用户账号详细信息")
    private AccountDetailDto accountDetail;

    @ApiModelProperty("今日浏览商品数量")
    private int browseNum;

    @ApiModelProperty("用户是否已被邀请过，用于控制是否可填写邀请码")
    private Boolean invited;
}
