package com.bxm.fossicker.user.model.param;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


@ApiModel(description = "登录基础通用参数")
@Data
@EqualsAndHashCode(callSuper = true)
public class BaseLoginParam extends BaseBean {

    @ApiModelProperty("当前用户操作系统版本，非APP则返回浏览器版本")
    private String osVersion;

    @ApiModelProperty("手机型号，非APP则返回浏览器型号")
    private String phoneModel;

    @ApiModelProperty("用户唯一设备号，非app选填")
    private String equipment;

    @ApiModelProperty(value = "邀请当前用户注册的用户ID，选填")
    private String inviteUserId;

    @ApiModelProperty(value = "用户注册途径如与某种业务关联，反馈该业务的ID，选填")
    private Long relationId;
}
