package com.bxm.fossicker.user.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@ApiModel(description = "微信登录参数")
@Data
@EqualsAndHashCode(callSuper = true)
public class WechatLoginParam extends BaseLoginParam {

    @ApiModelProperty(value = "微信的openId", required = true)
    private String openId;

    @ApiModelProperty(value = "微信的unionId", required = true)
    private String unionId;

    @ApiModelProperty(value = "微信昵称", required = true)
    private String nickName;

    @ApiModelProperty("微信头像，如果不存在将使用默认头像")
    private String headImg;
}
