package com.bxm.game.common.dal.entity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.game.common.dal.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货币流水记录（日分表，大数据使用）<br/>
 *
 * @author kerry.jiang
 * @date 2021/5/17 9:57
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(AssetsLogYmd.TABLE_NAME_DYNAMIC_MAPPING)
public class AssetsLogYmd extends BaseEntity {

    private static final long serialVersionUID = 1L;

    public static final String TABLE_NAME_DYNAMIC_MAPPING = "DynamicMappingForAssetsLogYmd";
    /**
     * 已存在的表名
     */
    public static final Set<String> TABLE_LIST = new HashSet<>();
    /**
     * 表名前缀
     */
    public static final String TABLE_PREFIX = "assets_log_";
    /**
     * 表名后缀格式（日表）
     */
    public static final String TABLE_SUFFIX_FORMAT = "yyyyMMdd";

    /**
     * 流水号
     */
    private String assetsNo;

    /**
     * appid
     */
    private String appId;

    /**
     * 变现猫用户ID
     */
    private String uid;

    /**
     * app用户ID
     */
    private String appUid;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 资产类型
     */
    private String assetType;

    /**
     * 资产数量
     */
    private Integer assetNum;

    /**
     * 操作类型,1:增加,2:扣除
     */
    private Integer operateType;

    /**
     * 操作状态,1:成功,2:失败
     */
    private Integer operateStatus;

    /**
     * 接口调用状态,1:正常,2:错误,3:超时
     */
    private Integer apiStatus;

    /**
     * 行为
     */
    private String act;

    private LocalDateTime createTime;


    public static final String ASSETS_NO = "assets_no";

    public static final String APP_ID = "app_id";

    public static final String UID = "uid";

    public static final String APP_UID = "app_uid";

    public static final String ACTIVITY_TYPE = "activity_type";

    public static final String ASSET_TYPE = "asset_type";

    public static final String ASSET_NUM = "asset_num";

    public static final String OPERATE_TYPE = "operate_type";

    public static final String OPERATE_STATUS = "operate_status";

    public static final String API_STATUS = "api_status";

    public static final String ACT = "act";

    public static final String CREATE_TIME = "create_time";

    public static String getTableName() {
        return getTableName(0);
    }

    public static String getTableName(int daysToAdd) {
        return TABLE_PREFIX + LocalDate.now().plusDays(daysToAdd)
                .format(DateTimeFormatter.ofPattern(TABLE_SUFFIX_FORMAT));
    }

}
