package com.bxm.game.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.bxm.game.common.dal.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author Allen Hu
 * @since 2021-01-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class Prize extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 奖品名称
     */
    private String name;

    /**
     * 奖品icon
     */
    private String icon;

    /**
     * 可兑换数量
     */
    private Integer exchange;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime modifyTime;

    /**
     * 活动类型
     */
    private String activityType;


    public static final String ID = "id";

    public static final String NAME = "name";

    public static final String ICON = "icon";

    public static final String EXCHANGE = "exchange";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String ACTIVITY_TYPE = "activity_type";

}
