package com.bxm.game.common.dal.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.game.common.dal.entity.AssetsLog;
import com.bxm.game.common.dal.model.AssetsLogRequest;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author Allen Hu
 * @since 2021-01-12
 */
public interface IAssetsLogService extends IService<AssetsLog> {

    /**
     * 数据表是否存在<br/>
     *
     * @param databaseName 数据库名
     * @param tableName 数据表名
     * @return
     */
    boolean existTable(String databaseName, String tableName);

    /**
     * 数据库不存在，则创建表<br/>
     *
     * @param databaseName 数据库名
     * @param tableName 数据表名
     */
    void createTableIfNecessary(String databaseName, String tableName);

    /**
     * 查询用户货币记录<br/>
     *
     * @param databaseName 数据库名
     * @param page 分页信息
     * @param request 请求参数
     * @return
     */
    Page<AssetsLog> pageByUid(String databaseName, Page page, AssetsLogRequest request);
}
