/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common;

import com.bxm.game.common.core.Key;
import com.bxm.game.mcat.common.util.MurmurHash;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.springframework.context.annotation.Configuration;

@Configuration
public class McatKey {
    private final Key key;

    public McatKey(Key key) {
        this.key = key;
    }

    public KeyGenerator hashComputeCache() {
        return this.key.generator(new String[]{"stepData", DateHelper.getDate(), "computeCache"});
    }

    public KeyGenerator hashWinnerRatio() {
        return this.key.generator(new String[]{"stepData", DateHelper.getDate(), "winnerRatio"});
    }

    public KeyGenerator setWinners(String assetType) {
        return this.key.generator(new String[]{"stepData", DateHelper.getDate(), "winners", assetType});
    }

    public KeyGenerator setForTicketOfToday(String assetType, long bucket) {
        String date = DateTimeFormatter.ofPattern("yyyyMMdd").format(LocalDate.now());
        return this.setForTicket(assetType, date, bucket);
    }

    public KeyGenerator setForTicketOfToday(String assetType, String id) {
        String date = DateTimeFormatter.ofPattern("yyyyMMdd").format(LocalDate.now());
        return this.setForTicket(assetType, date, id);
    }

    public KeyGenerator setForTicketOfYesterday(String assetType, long bucket) {
        String date = DateTimeFormatter.ofPattern("yyyyMMdd").format(LocalDate.now().plusDays(-1L));
        return this.setForTicket(assetType, date, bucket);
    }

    public KeyGenerator setForTicketWithoutToday(String assetType, long bucket) {
        return this.setForTicket(assetType, "0", bucket);
    }

    public KeyGenerator setForTicketWithoutToday(String assetType, String id) {
        return this.setForTicket(assetType, "0", id);
    }

    private KeyGenerator setForTicket(String assetType, String date, String id) {
        long hash64 = MurmurHash.hash64(id);
        long bucket = Math.abs(hash64 % 1000L);
        return this.setForTicket(assetType, date, bucket);
    }

    private KeyGenerator setForTicket(String assetType, String date, long bucket) {
        return this.key.generator(new String[]{"ticket", assetType, date, Objects.toString(bucket)});
    }

    public KeyGenerator bitmapAttendedOfToday() {
        String date = DateTimeFormatter.ofPattern("yyyyMMdd").format(LocalDate.now());
        return this.bitmapAttended(date);
    }

    public KeyGenerator bitmapAttended(String date) {
        return this.key.generator(new String[]{"attended", date});
    }

    public KeyGenerator bitOnline() {
        return this.key.generator(new String[]{"online"});
    }

    public KeyGenerator stringWithdrawId() {
        return this.key.generator(new String[]{"id", "withdraw"});
    }

    public static interface Field {

        public static interface ComputeCache {
            public static final String SYNC_STATE = "syncState";
            public static final String GRANT_COUNT = "grantCount";
            public static final String WINNER_COUNT = "winnerCount";
            public static final String BONUS = "bonus";
            public static final String MONEY = "money";
            public static final String WINNER_PROCESSING_STATE = "winnerProcessingState";
            public static final String ACCEPT_BONUS = "acceptBonus";
        }
    }
}

