/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.lobby;

import com.bxm.game.mcat.common.Constants;
import com.bxm.game.mcat.common.McatProperties;
import com.bxm.game.mcat.common.lobby.Lobby;
import com.bxm.game.mcat.common.lobby.LobbyService;
import com.bxm.game.mcat.common.session.OnlineService;
import com.bxm.game.mcat.common.ticket.statistics.StatisticsService;
import com.bxm.game.mcat.common.ticket.steps.StepDataTracker;
import com.bxm.game.mcat.common.ticket.winner.WinnerService;
import java.math.BigDecimal;
import java.time.LocalTime;
import org.springframework.stereotype.Service;

@Service
public class LobbyServiceImpl
implements LobbyService {
    private final McatProperties properties;
    private final StepDataTracker stepDataTracker;
    private final StatisticsService statisticsService;
    private final WinnerService winnerService;
    private final OnlineService onlineService;

    public LobbyServiceImpl(McatProperties properties, StepDataTracker stepDataTracker, StatisticsService statisticsService, WinnerService winnerService, OnlineService onlineService) {
        this.properties = properties;
        this.stepDataTracker = stepDataTracker;
        this.statisticsService = statisticsService;
        this.winnerService = winnerService;
        this.onlineService = onlineService;
    }

    @Override
    public Lobby get() {
        Lobby.LobbyBuilder builder = Lobby.builder();
        LocalTime now = LocalTime.now();
        builder.status(this.getStatus(now));
        builder.bonus(this.getBonus(now).longValue());
        builder.online(this.onlineService.online());
        builder.supply(this.stepDataTracker.getNotAcceptBonus());
        return builder.build();
    }

    private BigDecimal getBonus(LocalTime now) {
        if (now.isBefore(Constants.TWELVE)) {
            return BigDecimal.valueOf(this.stepDataTracker.getBonus()).multiply(BigDecimal.valueOf(this.properties.getShamBonusMultiply()));
        }
        return this.statisticsService.sumBonusOfToday();
    }

    private int getStatus(LocalTime now) {
        if (now.isBefore(Constants.EIGHT)) {
            return 0;
        }
        if (now.isBefore(Constants.TWELVE)) {
            return this.winnerService.isFinished() ? 2 : 1;
        }
        return 3;
    }
}

