/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.scene.home;

import com.bxm.game.common.core.archives.ObjectCustomArchiveHandler;
import com.bxm.game.common.core.assets.AssetService;
import com.bxm.game.mcat.common.McatProperties;
import com.bxm.game.mcat.common.prop.AssetType;
import com.bxm.game.mcat.common.scene.home.HomeArchive;
import com.bxm.game.mcat.common.ticket.statistics.StatisticsService;
import com.bxm.game.mcat.common.ticket.winner.WinnerService;
import java.math.BigDecimal;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HomeCustomArchiveHandler
implements ObjectCustomArchiveHandler<HomeArchive> {
    private final StatisticsService statisticsService;
    private final AssetService assetService;
    private final WinnerService winnerService;
    private final McatProperties mcatProperties;

    public HomeCustomArchiveHandler(StatisticsService statisticsService, AssetService assetService, WinnerService winnerService, McatProperties mcatProperties) {
        this.statisticsService = statisticsService;
        this.assetService = assetService;
        this.winnerService = winnerService;
        this.mcatProperties = mcatProperties;
    }

    public String getDisplayFieldName() {
        return "home";
    }

    public HomeArchive getArchiveObjects() {
        String[] all;
        BigDecimal total = this.statisticsService.sumBonusOfToday();
        BigDecimal oneMoney = this.statisticsService.getOnceMoneyOfToday(total);
        BigDecimal money = BigDecimal.ZERO;
        for (String assetType : all = AssetType.ALL) {
            long m = this.winnerService.computeMoney(oneMoney.longValue(), assetType);
            money = money.add(BigDecimal.valueOf(m).multiply(BigDecimal.valueOf(this.assetService.get(assetType))));
        }
        return HomeArchive.builder().bonus(total.longValue()).anticipate(money.compareTo(total) > 0 ? total.longValue() : money.longValue()).attenders(this.getAttenders().longValue()).build();
    }

    private BigDecimal getAttenders() {
        return BigDecimal.valueOf(this.statisticsService.getAttenders()).multiply(BigDecimal.valueOf(this.mcatProperties.getShamAttenderMultiply()));
    }
}

