/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.scene.video.conditional;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.prop.AcquiredPropLog;
import com.bxm.game.common.core.scene.acquire.AcquireConditional;
import com.bxm.game.common.core.user.TodayAtomicService;
import com.bxm.game.mcat.common.Constants;
import com.bxm.game.mcat.common.integration.UserIntegration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Profile(value={"vpc"})
@Configuration
public class ReleasePlayVideoAcquireConditionalImpl
implements AcquireConditional {
    private final UserIntegration userIntegration;
    private final TodayAtomicService todayAtomicService;

    public ReleasePlayVideoAcquireConditionalImpl(UserIntegration userIntegration, TodayAtomicService todayAtomicService) {
        this.userIntegration = userIntegration;
        this.todayAtomicService = todayAtomicService;
    }

    public String getSceneType() {
        return "play_video";
    }

    public boolean checked(AcquiredPropLog takeLog) {
        String appId = AppContext.get().getAppId();
        if (Constants.isTestAppId(appId)) {
            return true;
        }
        String uid = AppContext.get().getUid();
        long playVideoToday = this.userIntegration.getPlayVideoToday(appId, uid);
        return playVideoToday > this.todayAtomicService.get("play_video_finished");
    }
}

