/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.scene.video.listener;

import com.bxm.game.common.core.prop.AcquiredPropLog;
import com.bxm.game.common.core.prop.PropService;
import com.bxm.game.common.core.scene.AcquiringOrMultiplyPropEvent;
import com.bxm.game.common.core.user.TodayAtomicService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FinishedPlayVideoEventListener
implements EventListener<AcquiringOrMultiplyPropEvent> {
    private static final Logger log = LoggerFactory.getLogger(FinishedPlayVideoEventListener.class);
    private final TodayAtomicService todayAtomicService;
    private final PropService propService;

    public FinishedPlayVideoEventListener(TodayAtomicService todayAtomicService, PropService propService) {
        this.todayAtomicService = todayAtomicService;
        this.propService = propService;
    }

    @Subscribe
    public void consume(AcquiringOrMultiplyPropEvent event) {
        String id = event.getRequest().getId();
        AcquiredPropLog takeLog = this.propService.getTakeLog(id);
        AcquiredPropLog source = takeLog.getSource();
        if (Objects.isNull(source)) {
            log.warn("{} source log should be not null!", (Object)id);
            return;
        }
        if (!StringUtils.equals((String)source.getSceneType(), (String)"play_video")) {
            return;
        }
        this.todayAtomicService.increment("play_video_finished");
    }
}

