/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.session;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.mcat.common.session.OnlineService;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.annotation.Configuration;

@WebListener
@Configuration
public class OnlineHttpSessionListener
implements HttpSessionListener,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(OnlineHttpSessionListener.class);
    private final OnlineService onlineService;
    private final ThreadPoolExecutor destroy = new ThreadPoolExecutor(5, 10, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("offline"));

    public OnlineHttpSessionListener(OnlineService onlineService) {
        this.onlineService = onlineService;
    }

    public void sessionCreated(HttpSessionEvent se) {
        String uid = AppContext.get().getUid();
        if (Objects.isNull(uid)) {
            return;
        }
        HttpSession session = se.getSession();
        session.setAttribute("uid", (Object)uid);
        log.debug("{} sign up", (Object)uid);
        this.onlineService.online(uid);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        Object uid = session.getAttribute("uid");
        if (Objects.isNull(uid)) {
            return;
        }
        log.debug("{} sign out", uid);
        this.destroy.submit(() -> this.onlineService.offline(uid.toString()));
    }

    public void destroy() {
        this.destroy.shutdownNow();
    }
}

