/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.ticket.steps;

import com.bxm.game.mcat.common.McatProperties;
import com.bxm.game.mcat.common.ticket.steps.Step;
import com.bxm.game.mcat.common.ticket.steps.StepDataTracker;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ComputeMoneyStepImpl
implements Step {
    private static final Logger log = LoggerFactory.getLogger(ComputeMoneyStepImpl.class);
    private final McatProperties properties;
    private final StepDataTracker stepDataTracker;

    public ComputeMoneyStepImpl(McatProperties properties, StepDataTracker stepDataTracker) {
        this.properties = properties;
        this.stepDataTracker = stepDataTracker;
    }

    public int getOrder() {
        return 2;
    }

    @Override
    public void compute() {
        long grantCount = this.stepDataTracker.getGrantCount();
        long winnerCount = this.stepDataTracker.getWinnerCount();
        if (grantCount <= 0L || winnerCount <= 0L) {
            throw new RuntimeException("\u53ef\u4e2d\u5956\u6570\u91cf\u6216\u4e2d\u5956\u6570\u91cf\u4e3a 0");
        }
        BigDecimal bonus = BigDecimal.valueOf(this.properties.getEcpm()).movePointLeft(3).multiply(BigDecimal.valueOf(grantCount)).multiply(BigDecimal.valueOf(this.properties.getPercentOfEcpm()).movePointLeft(2)).movePointRight(3);
        long money = bonus.divide(BigDecimal.valueOf(winnerCount), 3, RoundingMode.HALF_UP).longValue();
        this.stepDataTracker.setBonus(bonus.longValue());
        this.stepDataTracker.setMoney(money);
        log.info("\u5956\u7b7e\u5355\u500d\u5956\u91d1\u8ba1\u7b97\u5b8c\u6210\uff1a{}", (Object)money);
    }
}

