/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.ticket.steps;

import com.bxm.game.mcat.common.ticket.statistics.StatisticsService;
import com.bxm.game.mcat.common.ticket.steps.Step;
import com.bxm.game.mcat.common.ticket.steps.StepDataTracker;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShakeWinnerStepImpl
implements Step {
    private static final Logger log = LoggerFactory.getLogger(ShakeWinnerStepImpl.class);
    private final StatisticsService statisticsService;
    private final StepDataTracker stepDataTracker;

    public ShakeWinnerStepImpl(StatisticsService statisticsService, StepDataTracker stepDataTracker) {
        this.statisticsService = statisticsService;
        this.stepDataTracker = stepDataTracker;
    }

    public int getOrder() {
        return 1;
    }

    @Override
    public void compute() {
        Map<String, String> ratios = this.stepDataTracker.getWinRatio();
        if (MapUtils.isEmpty(ratios)) {
            log.warn("\u5151\u5956\u6982\u7387\u8fd8\u6ca1\u6709\u8ba1\u7b97\u5b8c\u6210\uff0c\u65e0\u6cd5\u8fdb\u884c\u6447\u5956\u3002");
            return;
        }
        long winner = 0L;
        for (Map.Entry<String, String> entry : ratios.entrySet()) {
            String assetType = entry.getKey();
            String winRatio = entry.getValue();
            winner += this.shakeWinner(assetType, new BigDecimal(winRatio).movePointRight(6).intValue());
        }
        this.stepDataTracker.setWinnerCount(winner);
    }

    private long shakeWinner(String assetType, int winRatio) {
        if (winRatio == 0) {
            return 0L;
        }
        AtomicInteger hits = new AtomicInteger();
        log.info("{} \u5f00\u59cb\u6447\u5956", (Object)assetType);
        this.stepDataTracker.cleanWinners(assetType);
        this.statisticsService.consumeTicketWithoutToday(assetType, grants -> {
            int cursor = 1;
            int max = BigDecimal.ONE.movePointRight(6).intValue();
            HashSet winner = Sets.newHashSet();
            for (String id : grants) {
                boolean batchOrLastIndex;
                int hit = RandomUtils.nextInt((int)0, (int)max);
                if (winRatio > hit) {
                    winner.add(id);
                    hits.incrementAndGet();
                }
                boolean bl = batchOrLastIndex = hits.intValue() % 1000 == 0 || cursor == grants.size();
                if (batchOrLastIndex && CollectionUtils.isNotEmpty((Collection)winner)) {
                    this.stepDataTracker.addWinners(assetType, winner);
                    log.info("{} \u5df2\u5199\u5165\u4e2d\u5956\u5956\u7b7e {} \u4e2a", (Object)assetType, (Object)winner.size());
                    winner.clear();
                }
                ++cursor;
            }
        });
        log.info("{} \u7c7b\u578b\u7684\u5956\u7b7e\u4e00\u5171\u6447\u4e2d {} \u4e2a", (Object)assetType, (Object)hits);
        log.info("{} \u7c7b\u578b\u7684\u5956\u7b7e\u4e2d\u5956\u660e\u7ec6\u5df2\u8bb0\u5f55\u5b8c\u6210", (Object)assetType);
        return hits.intValue();
    }
}

