/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.mcat.common.withdraw;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.GameException;
import com.bxm.game.common.core.user.PermanentAtomicService;
import com.bxm.game.common.core.vo.BasePage;
import com.bxm.game.common.core.vo.Constructor;
import com.bxm.game.common.core.vo.Extractor;
import com.bxm.game.common.core.vo.PageHelper;
import com.bxm.game.common.dal.entity.PrizeLog;
import com.bxm.game.common.dal.enums.EPrizeLog;
import com.bxm.game.common.dal.service.IPrizeLogService;
import com.bxm.game.mcat.common.ErrCodes;
import com.bxm.game.mcat.common.McatKey;
import com.bxm.game.mcat.common.money.MoneyService;
import com.bxm.game.mcat.common.withdraw.WithdrawRequest;
import com.bxm.game.mcat.common.withdraw.WithdrawResponse;
import com.bxm.game.mcat.common.withdraw.WithdrawService;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.id.redis.RedisIdGenerator;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPool;

@Service
public class WithdrawServiceImpl
implements WithdrawService {
    private static final Logger log = LoggerFactory.getLogger(WithdrawServiceImpl.class);
    private final MoneyService moneyService;
    private final PermanentAtomicService permanentAtomicService;
    private final McatKey mcatKey;
    private IdGenerator idGenerator;
    private final AppConfigFetcher appConfigFetcher;
    private final IPrizeLogService iPrizeLogService;

    @Bean
    public IdGenerator withdraw(JedisPool jedisPool) {
        this.idGenerator = new RedisIdGenerator(24, this.mcatKey.stringWithdrawId().generateKey(), null, jedisPool);
        return this.idGenerator;
    }

    public WithdrawServiceImpl(MoneyService moneyService, IPrizeLogService iPrizeLogService, PermanentAtomicService permanentAtomicService1, McatKey mcatKey, AppConfigFetcher appConfigFetcher) {
        this.moneyService = moneyService;
        this.iPrizeLogService = iPrizeLogService;
        this.permanentAtomicService = permanentAtomicService1;
        this.mcatKey = mcatKey;
        this.appConfigFetcher = appConfigFetcher;
    }

    @Override
    public WithdrawResponse withdraw(WithdrawRequest request) {
        Integer amount = request.getAmount();
        WithdrawPackage withdrawPackage = WithdrawPackage.of(amount);
        if (Objects.isNull((Object)withdrawPackage)) {
            throw new GameException(ErrCodes.WITHDRAW_PACKAGE_ERR);
        }
        long money = this.moneyService.get();
        if (money < (long)amount.intValue()) {
            throw new GameException(ErrCodes.WITHDRAW_NOT_ENOUGH);
        }
        if (this.moneyService.minus(amount.intValue()) < 0L) {
            this.moneyService.plus(amount.intValue());
            throw new GameException(ErrCodes.WITHDRAW_NOT_ENOUGH);
        }
        if (withdrawPackage.isLimit() && this.isAboveOfPkgLimitWithIncrement(withdrawPackage)) {
            throw new GameException(ErrCodes.WITHDRAW_ABOVE_LIMIT);
        }
        try {
            PrizeLog prizeLog = new PrizeLog().setOrderId(this.idGenerator.next()).setAppId(AppContext.get().getAppId()).setUid(AppContext.get().getUid()).setAppUid("").setStatus(Integer.valueOf(EPrizeLog.Status.GRANT_PENDING.getId())).setPrizeId(Long.valueOf(0L)).setPrizeName(new BigDecimal((double)amount.intValue() / 1000.0).setScale(1, 4).toString()).setPrizeNum(Integer.valueOf(1)).setName(request.getName()).setMobile(request.getMobile()).setAddress("").setActivityType(this.appConfigFetcher.activityType()).setPayType(request.getPayType()).setAccount(request.getAccount()).setAmount(Integer.valueOf(amount / 10));
            if (!this.iPrizeLogService.save((Object)prizeLog)) {
                throw new GameException(ErrCodes.WITHDRAW_ERR);
            }
            log.info("PrizeLog: {}", (Object)prizeLog);
            return this.of(prizeLog);
        }
        catch (Exception e) {
            log.error("save: ", (Throwable)e);
            this.moneyService.plus(amount.intValue());
            if (withdrawPackage.isLimit()) {
                this.rollbackLimit(withdrawPackage);
            }
            throw new GameException(ErrCodes.WITHDRAW_ERR);
        }
    }

    private boolean isAboveOfPkgLimitWithIncrement(WithdrawPackage withdrawPackage) {
        return this.permanentAtomicService.increment(Objects.toString(withdrawPackage.amount), after -> after > (long)withdrawPackage.limit);
    }

    private void rollbackLimit(WithdrawPackage withdrawPackage) {
        this.permanentAtomicService.incrementBy(Objects.toString(withdrawPackage.amount), -1L);
    }

    private boolean isAboveOfPkgLimit(WithdrawPackage withdrawPackage) {
        return this.permanentAtomicService.get(Objects.toString(withdrawPackage.amount)) >= (long)withdrawPackage.limit;
    }

    @Override
    public IPage<WithdrawResponse> list(BasePage basePage) {
        return PageHelper.selectForObject((int)basePage.getCurrent(), (int)basePage.getSize(), (Extractor)new Extractor<PrizeLog>(){

            public IPage<PrizeLog> extract(IPage<PrizeLog> page) {
                QueryWrapper query = Wrappers.query((Object)new PrizeLog().setAppId(AppContext.get().getAppId()).setUid(AppContext.get().getUid()).setActivityType(WithdrawServiceImpl.this.appConfigFetcher.activityType()));
                query.orderByDesc((Object)"create_time");
                return WithdrawServiceImpl.this.iPrizeLogService.page(page, (Wrapper)query);
            }
        }, (Constructor)new Constructor<PrizeLog, WithdrawResponse>(){

            public WithdrawResponse construct(PrizeLog e) {
                return WithdrawServiceImpl.this.of(e);
            }
        });
    }

    @Override
    public List<Integer> getPkg() {
        WithdrawPackage[] packages;
        ArrayList rst = Lists.newArrayList();
        for (WithdrawPackage p : packages = WithdrawPackage.values()) {
            if (p.isLimit() && this.isAboveOfPkgLimit(p)) continue;
            rst.add(p.amount);
        }
        int max = 4;
        if (rst.size() > max) {
            Object[] dest = new Integer[max];
            System.arraycopy(rst.toArray(new Integer[0]), 0, dest, 0, max);
            return Lists.newArrayList((Object[])dest);
        }
        return rst;
    }

    private WithdrawResponse of(PrizeLog e) {
        return new WithdrawResponse().setId(e.getId()).setAppId(e.getAppId()).setUid(e.getUid()).setOrderId(e.getOrderId()).setName(e.getName()).setMobile(e.getMobile()).setAccount(e.getAccount()).setAmount(e.getAmount() * 10).setStatus(e.getStatus()).setCreateTime(e.getCreateTime());
    }

    static enum WithdrawPackage {
        Jiao3(300, 1),
        Yuan1(1000, 0),
        Yuan3(3000, 0),
        Yuan5(5000, 0),
        Yuan10(10000, 0);

        private int amount;
        private int limit;

        private WithdrawPackage(int amount, int limit) {
            this.amount = amount;
            this.limit = limit;
        }

        boolean isLimit() {
            return this.limit > 0;
        }

        public static WithdrawPackage of(int amount) {
            WithdrawPackage[] values;
            for (WithdrawPackage value : values = WithdrawPackage.values()) {
                if (value.amount != amount) continue;
                return value;
            }
            return null;
        }
    }
}

