package com.bxm.game.scene.common.dal.autoconfigure;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.reflection.MetaObject;
import org.springframework.context.annotation.Bean;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.extension.parsers.DynamicTableNameParser;
import com.baomidou.mybatisplus.extension.parsers.ITableNameHandler;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.bxm.game.scene.common.dal.entity.AcquiredPropLog;
import com.bxm.game.scene.common.dal.entity.AssetsLog;
import com.bxm.game.scene.common.dal.entity.AssetsLogYmd;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * @author allen
 * @date 2020-04-15
 * @since 1.0
 */
public class MyBatisPlusAutoConfiguration {

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        DynamicTableNameParser dynamicTableNameParser = new DynamicTableNameParser();

        Map<String, ITableNameHandler> tableNameHandlerMap = Maps.newHashMap();
        tableNameHandlerMap.put(AcquiredPropLog.TABLE_NAME_DYNAMIC_MAPPING, new ITableNameHandler() {
            @Override
            public String dynamicTableName(MetaObject metaObject, String sql, String tableName) {
                return AcquiredPropLog.getTableName();
            }
        });
        tableNameHandlerMap.put(AssetsLog.TABLE_NAME_DYNAMIC_MAPPING, new ITableNameHandler() {
            @Override
            public String dynamicTableName(MetaObject metaObject, String sql, String tableName) {
                return AssetsLog.getTableName();
            }
        });
        tableNameHandlerMap.put(AssetsLogYmd.TABLE_NAME_DYNAMIC_MAPPING, new ITableNameHandler() {
            @Override
            public String dynamicTableName(MetaObject metaObject, String sql, String tableName) {
                return AssetsLogYmd.getTableName();
            }
        });
        dynamicTableNameParser.setTableNameHandlerMap(tableNameHandlerMap);
        List<ISqlParser> parsers = Lists.newArrayList(dynamicTableNameParser);
        PaginationInterceptor interceptor = new PaginationInterceptor();
        interceptor.setSqlParserList(parsers);
        return interceptor;
    }
}
