package com.bxm.game.scene.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.bxm.game.scene.common.dal.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 奖品兑现纪录
 * </p>
 *
 * @author Allen Hu
 * @since 2021-10-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PrizeLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 订单号
     */
    private String orderId;

    /**
     * 游戏代码
     */
    private String gameCode;

    /**
     * appid
     */
    private String appId;

    /**
     * 变现猫用户ID
     */
    private String uid;

    /**
     * app用户ID
     */
    private String appUid;

    /**
     * 状态,1:待发放,2:已发放,3:已放弃,5:填写信息
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime modifyTime;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品描述
     */
    private String prizeDescription;

    /**
     * 奖品数量
     */
    private Integer prizeNum;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机
     */
    private String mobile;

    /**
     * 地址
     */
    private String address;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 支付渠道,0:无,1:支付宝,2:微信 3:话费充值
     */
    private Integer payType;

    /**
     * 收款账号
     */
    private String account;

    /**
     * 提现金额,单位: 分
     */
    private Integer amount;

    /**
     * 物流单号
     */
    private String trackingNum;

    /**
     * 支付宝userId
     */
    private String userId;

    /**
     * 奖品图片地址
     */
    private String prizeIcon;


    public static final String ID = "id";

    public static final String ORDER_ID = "order_id";

    public static final String GAME_CODE = "game_code";

    public static final String APP_ID = "app_id";

    public static final String UID = "uid";

    public static final String APP_UID = "app_uid";

    public static final String STATUS = "status";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String PRIZE_ID = "prize_id";

    public static final String PRIZE_NAME = "prize_name";

    public static final String PRIZE_NUM = "prize_num";

    public static final String NAME = "name";

    public static final String MOBILE = "mobile";

    public static final String ADDRESS = "address";

    public static final String ACTIVITY_TYPE = "activity_type";

    public static final String PAY_TYPE = "pay_type";

    public static final String ACCOUNT = "account";

    public static final String AMOUNT = "amount";

    public static final String TRACKING_NUM = "tracking_num";

}
