package com.bxm.game.scene.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.game.scene.common.dal.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户与支付宝绑定关系表
 * </p>
 *
 * @author Allen Hu
 * @since 2022-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("user_alipay_bind_record")
public class UserAlipayBindRecord extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * appid
     */
    private String appid;

    /**
     * 变现猫用户id
     */
    private String uid;

    /**
     * app用户id
     */
    private String appUid;

    /**
     * 支付宝用户id
     */
    private String userId;

    /**
     * 授权完成支付宝返回的authCode
     */
    private String authCode;

    /**
     * 与支付宝绑定时间
     */
    private LocalDateTime bindTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 用户头像地址
     */
    private String avatar;
    /**
     * 市名称。
     */
    private String city;
    /**
     * 用户昵称
     */
    private String nickName;
    /**
     * 省份名称
     */
    private String province;
    /**
     * 性别。枚举值如下：
     * F：女性；
     * M：男性。
     */
    private String gender;


    public static final String ID = "id";

    public static final String APPID = "appid";

    public static final String UID = "uid";

    public static final String APP_UID = "app_uid";

    public static final String USER_ID = "user_id";

    public static final String AUTH_CODE = "auth_code";

    public static final String IS_SUPPORT_BIND = "is_support_bind";

    public static final String BIND_TIME = "bind_time";

    public static final String CREATE_TIME = "create_time";

}
