package com.bxm.game.scene.common.dal.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.game.scene.common.dal.entity.AssetsLog;
import com.bxm.game.scene.common.dal.model.AssetsLogRequest;

/**
 * 货币流水记录（月分表，记录查询）<br/>
 *
 * @author kerry.jiang
 * @date 2021/5/17 10:37
 */
public interface AssetsLogMapper extends BaseMapper<AssetsLog> {

    /**
     * 数据表是否存在<br/>
     *
     * @param databaseName 数据库名
     * @param tableName 数据表名
     * @return
     */
    int existTable(@Param("databaseName") String databaseName,
                   @Param("tableName") String tableName);

    /**
     * 创建表<br/>
     *
     * @param tableName 数据表名
     * @return
     */
    int createTable(@Param("tableName") String tableName);

    /**
     * 查询用户货币记录<br/>
     *
     * @param tableNames 表名
     * @param request 请求参数
     * @return
     */
    Page<AssetsLog> pageByUid(Page page,@Param("tableNames") List<String> tableNames,
                                            @Param("rq") AssetsLogRequest request);

    /**
     * 查询用户货币记录<br/>
     *
     * @param tableNames 表名
     * @param request 请求参数
     * @return
     */
    List<AssetsLog> pageByUid(@Param("tableNames") List<String> tableNames,
                                            @Param("rq") AssetsLogRequest request);
}
